/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MergeLinkedAccountsResourcesPanel;
import org.apache.syncope.client.console.panels.MergeLinkedAccountsReviewPanel;
import org.apache.syncope.client.console.panels.MergeLinkedAccountsSearchPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.any.MergeLinkedAccountsWizardModel;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.patch.LinkedAccountPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.model.IModel;

public class MergeLinkedAccountsWizardBuilder
extends AjaxWizardBuilder<UserTO>
implements IEventSink {
    private static final long serialVersionUID = -9142332740863374891L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final UserDirectoryPanel parentPanel;
    private final BaseModal<?> modal;
    private MergeLinkedAccountsWizardModel model;

    public MergeLinkedAccountsWizardBuilder(IModel<UserTO> model, PageReference pageRef, UserDirectoryPanel parentPanel, BaseModal<?> modal) {
        super((Serializable)model.getObject(), pageRef);
        this.parentPanel = parentPanel;
        this.modal = modal;
    }

    @Override
    protected WizardModel buildModelSteps(UserTO modelObject, WizardModel wizardModel) {
        this.model = new MergeLinkedAccountsWizardModel(modelObject);
        wizardModel.add((IWizardStep)new MergeLinkedAccountsSearchPanel(this.model, this.getPageReference()));
        wizardModel.add((IWizardStep)new MergeLinkedAccountsResourcesPanel(this.model, this.getPageReference()));
        wizardModel.add((IWizardStep)new MergeLinkedAccountsReviewPanel(this.model, this.getPageReference()));
        return wizardModel;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
            ((AjaxWizard.NewItemCancelEvent)event.getPayload()).getTarget().ifPresent(arg_0 -> this.modal.close(arg_0));
        }
        if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
            Optional<AjaxRequestTarget> target = ((AjaxWizard.NewItemFinishEvent)event.getPayload()).getTarget();
            try {
                this.mergeAccounts();
                this.parentPanel.info((Serializable)((Object)this.parentPanel.getString("operation_succeeded")));
                target.ifPresent(t -> {
                    ((BasePage)this.parentPanel.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)t);
                    this.parentPanel.updateResultTable((AjaxRequestTarget)t);
                    this.modal.close((IPartialPageRequestHandler)t);
                });
            }
            catch (Exception e) {
                this.parentPanel.error((Serializable)((Object)(this.parentPanel.getString("error") + ": " + e.getMessage())));
                target.ifPresent(t -> ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)t));
            }
        }
    }

    private void mergeAccounts() throws Exception {
        UserTO mergingUserTO = this.model.getMergingUser();
        ResourceRestClient resourceRestClient = new ResourceRestClient();
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(this.model.getBaseUser().getUsername());
        mergingUserTO.getLinkedAccounts().forEach(acct -> {
            LinkedAccountTO linkedAccount = new LinkedAccountTO.Builder(acct.getResource(), acct.getConnObjectKeyValue()).password(acct.getPassword()).suspended(acct.isSuspended()).username(acct.getUsername()).build();
            linkedAccount.getPlainAttrs().addAll(acct.getPlainAttrs());
            linkedAccount.getPrivileges().addAll(acct.getPrivileges());
            LinkedAccountPatch patch = (LinkedAccountPatch)((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().linkedAccountTO(linkedAccount).operation(PatchOperation.ADD_REPLACE)).build();
            userPatch.getLinkedAccounts().add(patch);
        });
        mergingUserTO.getResources().forEach(resource -> {
            String connObjectKeyValue = resourceRestClient.getConnObjectKeyValue((String)resource, mergingUserTO.getType(), mergingUserTO.getKey());
            LinkedAccountTO linkedAccount = new LinkedAccountTO.Builder(resource, connObjectKeyValue).build();
            linkedAccount.getPlainAttrs().addAll(mergingUserTO.getPlainAttrs());
            linkedAccount.getPrivileges().addAll(mergingUserTO.getPrivileges());
            LinkedAccountPatch patch = (LinkedAccountPatch)((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().linkedAccountTO(linkedAccount).operation(PatchOperation.ADD_REPLACE)).build();
            userPatch.getLinkedAccounts().add(patch);
        });
        String connObjectKeyValue = resourceRestClient.getConnObjectKeyValue(this.model.getResource().getKey(), mergingUserTO.getType(), mergingUserTO.getKey());
        LinkedAccountTO linkedAccount = new LinkedAccountTO.Builder(this.model.getResource().getKey(), connObjectKeyValue).password(mergingUserTO.getPassword()).suspended(mergingUserTO.isSuspended()).username(mergingUserTO.getUsername()).build();
        linkedAccount.getPlainAttrs().addAll(mergingUserTO.getPlainAttrs());
        linkedAccount.getPrivileges().addAll(mergingUserTO.getPrivileges());
        LinkedAccountPatch patch = (LinkedAccountPatch)((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().linkedAccountTO(linkedAccount).operation(PatchOperation.ADD_REPLACE)).build();
        userPatch.getLinkedAccounts().add(patch);
        BatchRequest batchRequest = SyncopeConsoleSession.get().batch();
        BatchRequestItem deleteRequest = new BatchRequestItem();
        deleteRequest.setMethod("DELETE");
        deleteRequest.setRequestURI("/users/" + mergingUserTO.getKey());
        deleteRequest.getHeaders().put("Content-Type", Collections.singletonList("application/json"));
        batchRequest.getItems().add(deleteRequest);
        String updateUserPayload = MAPPER.writeValueAsString((Object)userPatch);
        BatchRequestItem updateUser = new BatchRequestItem();
        updateUser.setMethod("PATCH");
        updateUser.setRequestURI("/users/" + this.model.getBaseUser().getUsername());
        updateUser.setHeaders(new HashMap());
        updateUser.getHeaders().put("Prefer", Collections.singletonList(Preference.RETURN_NO_CONTENT.toString()));
        updateUser.getHeaders().put("Accept", Collections.singletonList("application/json"));
        updateUser.getHeaders().put("Content-Type", Collections.singletonList("application/json"));
        updateUser.getHeaders().put("Content-Length", Collections.singletonList(updateUserPayload.length()));
        updateUser.setContent(updateUserPayload);
        batchRequest.getItems().add(updateUser);
        Map<String, String> batchResponse = new UserRestClient().batch(batchRequest);
        batchResponse.forEach((key, value) -> {
            if (!value.equalsIgnoreCase("success")) {
                throw new IllegalArgumentException("Unable to report a success operation status for " + key);
            }
        });
    }
}

