/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.AlignmentBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.GlyphIconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.WebMarkupContainerNoVeil;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Response;

public class RealmChoicePanel
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    private static final String SEARCH_REALMS = "searchRealms";
    private final RealmRestClient realmRestClient = new RealmRestClient();
    private final PageReference pageRef;
    private final LoadableDetachableModel<List<Pair<String, RealmTO>>> realmTree;
    private final LoadableDetachableModel<List<DynRealmTO>> dynRealmTree;
    private final WebMarkupContainerNoVeil container;
    private Model<RealmTO> model;
    private final Collection<String> availableRealms;
    private final Map<String, Pair<RealmTO, List<RealmTO>>> tree;
    private final List<AbstractLink> links = new ArrayList<AbstractLink>();
    private String searchQuery;
    private List<RealmTO> realmsChoices;
    private final boolean isSearchEnabled;

    public RealmChoicePanel(String id, PageReference pageRef) {
        super(id);
        this.pageRef = pageRef;
        this.availableRealms = SyncopeConsoleSession.get().getSearchableRealms();
        this.tree = new HashMap<String, Pair<RealmTO, List<RealmTO>>>();
        this.isSearchEnabled = RealmsUtils.isSearchEnabled(SyncopeConsoleSession.get().getSearchableRealms());
        this.realmTree = new LoadableDetachableModel<List<Pair<String, RealmTO>>>(){
            private static final long serialVersionUID = -7688359318035249200L;

            private void getChildren(List<Pair<String, RealmTO>> full, String key, Map<String, Pair<RealmTO, List<RealmTO>>> tree, String indent) {
                if (tree.containsKey(key)) {
                    Pair<RealmTO, List<RealmTO>> subtree = tree.get(key);
                    ((List)subtree.getValue()).forEach(child -> {
                        full.add(Pair.of((Object)(indent + child.getName()), (Object)child));
                        this.getChildren(full, child.getKey(), tree, "     " + indent + (indent.isEmpty() ? "|--- " : ""));
                    });
                }
            }

            protected List<Pair<String, RealmTO>> load() {
                Map map = RealmChoicePanel.this.reloadRealmParentMap();
                List<Object> full = new ArrayList<Pair<String, RealmTO>>();
                if (RealmChoicePanel.this.isSearchEnabled) {
                    full = map.entrySet().stream().map(el -> Pair.of(el.getKey(), (Object)((Pair)el.getValue()).getKey())).collect(Collectors.toList());
                } else {
                    this.getChildren(full, null, map, "");
                }
                return full.stream().filter(realm -> RealmChoicePanel.this.availableRealms.stream().anyMatch(availableRealm -> ((RealmTO)realm.getValue()).getFullPath().startsWith((String)availableRealm))).collect(Collectors.toList());
            }
        };
        this.dynRealmTree = new LoadableDetachableModel<List<DynRealmTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<DynRealmTO> load() {
                List<DynRealmTO> dynRealms = RealmChoicePanel.this.realmRestClient.listDynReams();
                dynRealms.sort((left, right) -> {
                    if (left == null) {
                        return -1;
                    }
                    if (right == null) {
                        return 1;
                    }
                    return left.getKey().compareTo(right.getKey());
                });
                return dynRealms.stream().filter(dynRealm -> RealmChoicePanel.this.availableRealms.stream().anyMatch(availableRealm -> "/".equals(availableRealm) || dynRealm.getKey().equals(availableRealm))).collect(Collectors.toList());
            }
        };
        RealmTO realmTO = SyncopeConsoleSession.get().getRootRealm().map(rootRealm -> {
            String rootRealmName = StringUtils.substringAfterLast((String)rootRealm, (String)"/");
            List realmTOs = this.realmRestClient.search(RealmsUtils.buildQuery("/".equals(rootRealm) ? "/" : rootRealmName)).getResult();
            return realmTOs.stream().filter(realm -> rootRealm.equals(realm.getFullPath())).findFirst().orElseGet(() -> {
                RealmTO placeholder = new RealmTO();
                placeholder.setName(rootRealmName);
                placeholder.setFullPath(rootRealm);
                return placeholder;
            });
        }).orElseGet(() -> new RealmTO());
        this.model = Model.of((Serializable)realmTO);
        this.searchQuery = realmTO.getName();
        this.container = new WebMarkupContainerNoVeil("container", (IModel<?>)this.realmTree);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.reloadRealmTree();
    }

    public final void reloadRealmTree() {
        final Label realmLabel = new Label("realmLabel", (IModel)new Model());
        realmLabel.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{realmLabel});
        if (StringUtils.startsWith((CharSequence)((RealmTO)this.model.getObject()).getFullPath(), (CharSequence)"/")) {
            realmLabel.setDefaultModel((IModel)new ResourceModel("realmLabel", "Realm"));
        } else {
            realmLabel.setDefaultModel((IModel)new ResourceModel("dynRealmLabel", "Dynamic Realm"));
        }
        final Label label = new Label("realm", (Serializable)((Object)((RealmTO)this.model.getObject()).getFullPath()));
        label.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{label});
        if (this.isSearchEnabled) {
            this.realmsChoices = this.buildRealmChoices();
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(false);
            settings.setShowListOnEmptyInput(false);
            AutoCompleteTextField<String> searchRealms = new AutoCompleteTextField<String>(SEARCH_REALMS, (IModel)new Model(), settings){
                private static final long serialVersionUID = -6635259975264955783L;

                protected Iterator<String> getChoices(String input) {
                    RealmChoicePanel.this.searchQuery = input;
                    RealmChoicePanel.this.realmsChoices = RealmsUtils.checkInput(input) ? RealmChoicePanel.this.buildRealmChoices() : Collections.emptyList();
                    return RealmChoicePanel.this.realmsChoices.stream().map(item -> item.getFullPath()).sorted().collect(Collectors.toList()).iterator();
                }

                protected AutoCompleteBehavior<String> newAutoCompleteBehavior(IAutoCompleteRenderer<String> renderer, AutoCompleteSettings settings) {
                    return super.newAutoCompleteBehavior((IAutoCompleteRenderer)new AbstractAutoCompleteRenderer<String>(){
                        private static final long serialVersionUID = -4789925973199139157L;

                        protected void renderChoice(String object, Response response, String criteria) {
                            response.write((CharSequence)object);
                        }

                        protected String getTextValue(String object) {
                            return object;
                        }
                    }, settings);
                }
            };
            searchRealms.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change", (AutoCompleteTextField)searchRealms, label, realmLabel){
                private static final long serialVersionUID = -6139318907146065915L;
                final /* synthetic */ AutoCompleteTextField val$searchRealms;
                final /* synthetic */ Label val$label;
                final /* synthetic */ Label val$realmLabel;
                {
                    this.val$searchRealms = autoCompleteTextField;
                    this.val$label = label;
                    this.val$realmLabel = label2;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    RealmChoicePanel.this.realmsChoices.stream().filter(item -> item.getFullPath().equals(this.val$searchRealms.getModelObject())).findFirst().ifPresent(realm -> {
                        RealmChoicePanel.this.model.setObject((Serializable)realm);
                        this.val$label.setDefaultModelObject((Object)((RealmTO)RealmChoicePanel.this.model.getObject()).getFullPath());
                        this.val$realmLabel.setDefaultModel((IModel)new ResourceModel("realmLabel", "Realm"));
                        target.add(new Component[]{this.val$label});
                        RealmChoicePanel.this.send((IEventSink)RealmChoicePanel.this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>((RealmTO)realm, target));
                    });
                }
            }});
            Fragment fragment = new Fragment("realmsFragment", "realmsSearchFragment", (MarkupContainer)this.container);
            fragment.addOrReplace(new Component[]{searchRealms});
            this.container.addOrReplace(new Component[]{fragment});
        } else {
            DropDownButton realms = new DropDownButton("realms", (IModel)new ResourceModel("select", ""), (IModel)new Model((Serializable)GlyphIconType.folderopen)){
                private static final long serialVersionUID = -5560086780455361131L;

                protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                    RealmChoicePanel.this.buildRealmLinks(label, realmLabel);
                    return RealmChoicePanel.this.links;
                }
            };
            realms.setOutputMarkupId(true);
            realms.setAlignment(AlignmentBehavior.Alignment.RIGHT);
            realms.setType(Buttons.Type.Menu);
            MetaDataRoleAuthorizationStrategy.authorize((Component)realms, (Action)ENABLE, (String)"REALM_LIST");
            Fragment fragment = new Fragment("realmsFragment", "realmsListFragment", (MarkupContainer)this.container);
            fragment.addOrReplace(new Component[]{realms});
            this.container.addOrReplace(new Component[]{fragment});
        }
    }

    private void buildRealmLinks(final Label label, final Label realmLabel) {
        this.links.clear();
        this.links.add((AbstractLink)new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("realms", "Realms")){
            private static final long serialVersionUID = -7978723352517770744L;

            public void onClick(AjaxRequestTarget target) {
            }

            public boolean isEnabled() {
                return false;
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.put("class", (CharSequence)"panel box box-primary box-header with-border");
                tag.put("style", (CharSequence)"margin: 20px 5px 0px 5px; width: 90%");
            }
        });
        ((List)this.realmTree.getObject()).forEach(link -> {
            final RealmTO realmTO = (RealmTO)link.getValue();
            this.links.add((AbstractLink)new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)Model.of((Serializable)realmTO), Buttons.Type.Link, (IModel)new Model((Serializable)link.getKey())){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    RealmChoicePanel.this.model.setObject((Serializable)realmTO);
                    label.setDefaultModelObject((Object)((RealmTO)RealmChoicePanel.this.model.getObject()).getFullPath());
                    realmLabel.setDefaultModel((IModel)new ResourceModel("realmLabel", "Realm"));
                    target.add(new Component[]{label});
                    this.send((IEventSink)RealmChoicePanel.this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>(realmTO, target));
                }
            });
        });
        if (!((List)this.dynRealmTree.getObject()).isEmpty()) {
            this.links.add((AbstractLink)new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("dynrealms", "Dynamic Realms")){
                private static final long serialVersionUID = -7978723352517770744L;

                public void onClick(AjaxRequestTarget target) {
                }

                public boolean isEnabled() {
                    return false;
                }

                protected void onComponentTag(ComponentTag tag) {
                    tag.put("class", (CharSequence)"panel box box-primary box-header with-border");
                    tag.put("style", (CharSequence)"margin: 20px 5px 0px 5px; width: 90%");
                }
            });
            ((List)this.dynRealmTree.getObject()).forEach(dynRealmTO -> {
                final RealmTO realmTO = new RealmTO();
                realmTO.setKey(dynRealmTO.getKey());
                realmTO.setName(dynRealmTO.getKey());
                realmTO.setFullPath(dynRealmTO.getKey());
                this.links.add((AbstractLink)new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new Model((Serializable)((Object)realmTO.getKey()))){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        RealmChoicePanel.this.model.setObject((Serializable)realmTO);
                        label.setDefaultModelObject((Object)realmTO.getKey());
                        realmLabel.setDefaultModel((IModel)new ResourceModel("dynRealmLabel", "Dynamic Realm"));
                        target.add(new Component[]{label});
                        this.send((IEventSink)RealmChoicePanel.this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>(realmTO, target));
                    }
                });
            });
        }
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target) {
        this.reloadRealmTree();
        target.add(new Component[]{this.container});
        return this;
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target, Model<RealmTO> newModel) {
        this.model = newModel;
        this.reloadRealmTree(target);
        return this;
    }

    private Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap() {
        List realmsToList = this.isSearchEnabled ? this.realmRestClient.search(RealmsUtils.buildQuery(this.searchQuery)).getResult() : this.realmRestClient.list();
        return this.reloadRealmParentMap(realmsToList.stream().sorted(Comparator.comparing(RealmTO::getName)).collect(Collectors.toList()));
    }

    private Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap(List<RealmTO> realms) {
        this.tree.clear();
        if (!this.isSearchEnabled) {
            this.tree.put(null, (Pair<RealmTO, List<RealmTO>>)Pair.of((Object)realms.get(0), new ArrayList()));
        }
        HashMap cache = new HashMap();
        realms.forEach(realm -> {
            ArrayList children = new ArrayList();
            this.tree.put(realm.getKey(), (Pair<RealmTO, List<RealmTO>>)Pair.of((Object)realm, children));
            if (cache.containsKey(realm.getKey())) {
                children.addAll((Collection)cache.get(realm.getKey()));
                cache.remove(realm.getKey());
            }
            if (this.tree.containsKey(realm.getParent())) {
                ((List)this.tree.get(realm.getParent()).getRight()).add(realm);
            } else if (cache.containsKey(realm.getParent())) {
                ((List)cache.get(realm.getParent())).add(realm);
            } else {
                cache.put(realm.getParent(), Stream.of(realm).collect(Collectors.toList()));
            }
        });
        return this.tree;
    }

    private List<RealmTO> buildRealmChoices() {
        return Stream.of(((List)this.realmTree.getObject()).stream().map(item -> (RealmTO)item.getValue()).collect(Collectors.toList()), ((List)this.dynRealmTree.getObject()).stream().map(item -> {
            RealmTO realmTO = new RealmTO();
            realmTO.setKey(item.getKey());
            realmTO.setName(item.getKey());
            realmTO.setFullPath(item.getKey());
            return realmTO;
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public RealmTO getCurrentRealm() {
        return (RealmTO)this.model.getObject();
    }

    public void setCurrentRealm(RealmTO realmTO) {
        this.model.setObject((Serializable)realmTO);
    }

    public RealmTO moveToParentRealm(String key) {
        for (Pair<RealmTO, List<RealmTO>> subtree : this.tree.values()) {
            for (RealmTO child : (List)subtree.getRight()) {
                if (child.getKey() == null || !child.getKey().equals(key)) continue;
                this.model.setObject((Serializable)subtree.getLeft());
                return (RealmTO)subtree.getLeft();
            }
        }
        return null;
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    public static class ChosenRealm<T> {
        private final AjaxRequestTarget target;
        private final T obj;

        public ChosenRealm(T obj, AjaxRequestTarget target) {
            this.obj = obj;
            this.target = target;
        }

        public T getObj() {
            return this.obj;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

