/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.syncope.client.console.commons.SchemaUtils;
import org.apache.syncope.client.console.panels.ParametersCreateWizardPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ParametersCreateWizardAttrStep
extends WizardStep {
    private static final long serialVersionUID = -7843275202297616553L;
    private final AjaxTextFieldPanel schema;

    public ParametersCreateWizardAttrStep(final ParametersCreateWizardPanel.ParametersForm modelObject) {
        this.setOutputMarkupId(true);
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.add(new Component[]{content});
        this.schema = new AjaxTextFieldPanel("schema", this.getString("schema"), (IModel<String>)new PropertyModel((Object)modelObject.getAttrTO(), "schema"));
        this.schema.setRequired(true);
        content.add(new Component[]{this.schema});
        LoadableDetachableModel<List<PlainSchemaTO>> loadableDetachableModel = new LoadableDetachableModel<List<PlainSchemaTO>>(){
            private static final long serialVersionUID = 7172461137064525667L;

            protected List<PlainSchemaTO> load() {
                return Arrays.asList(modelObject.getPlainSchemaTO());
            }
        };
        ListView<PlainSchemaTO> listView = new ListView<PlainSchemaTO>("attrs", (IModel)loadableDetachableModel){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<PlainSchemaTO> item) {
                item.add(new Component[]{ParametersCreateWizardAttrStep.this.getFieldPanel("panel", modelObject.getAttrTO(), (PlainSchemaTO)item.getModelObject())});
            }
        };
        content.add(new Component[]{listView});
    }

    private Panel getFieldPanel(String id, AttrTO attrTO, PlainSchemaTO plainSchema) {
        FieldPanel panel;
        String valueHeaderName = this.getString("values");
        switch (plainSchema.getType()) {
            case Date: {
                String dataPattern;
                String string = dataPattern = plainSchema.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : plainSchema.getConversionPattern();
                if (dataPattern.contains("H")) {
                    panel = new AjaxDateTimeFieldPanel(id, valueHeaderName, (IModel<Date>)new Model(), dataPattern);
                    break;
                }
                panel = new AjaxDateFieldPanel("panel", valueHeaderName, (IModel<Date>)new Model(), dataPattern);
                break;
            }
            case Boolean: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(Arrays.asList("true", "false"));
                if (!attrTO.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;

                        public String getDisplayValue(String value) {
                            return value;
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid(false);
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues(plainSchema));
                if (!attrTO.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;

                        public String getDisplayValue(String value) {
                            return value;
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid("true".equalsIgnoreCase(plainSchema.getMandatoryCondition()));
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder<Long>().build(id, valueHeaderName, Long.class, (IModel<Long>)new Model());
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder<Double>().build(id, valueHeaderName, Double.class, (IModel<Double>)new Model());
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), plainSchema.getMimeType(), (String)this.schema.getModelObject());
                break;
            }
            case Encrypted: {
                panel = "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(plainSchema.getConversionPattern()) ? new AjaxTextFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), false) : new EncryptedFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), true);
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel(id, valueHeaderName, (IModel<String>)new Model(), false);
            }
        }
        if (plainSchema.isMultivalue()) {
            return new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build(id, valueHeaderName, panel);
        }
        panel.setNewModel(attrTO.getValues());
        panel.setRequired("true".equalsIgnoreCase(plainSchema.getMandatoryCondition()));
        return panel;
    }
}

