/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SyncopeConsoleSession
extends AuthenticatedWebSession {
    private static final long serialVersionUID = 747562246415852166L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeConsoleSession.class);
    protected final SyncopeClientFactoryBean clientFactory;
    protected final SyncopeClient anonymousClient;
    protected final PlatformInfo platformInfo;
    protected final SystemInfo systemInfo;
    protected final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    protected final ThreadPoolTaskExecutor executor;
    protected String domain;
    protected SyncopeClient client;
    protected UserTO selfTO;
    protected Map<String, Set<String>> auth;
    protected Roles roles;

    public static SyncopeConsoleSession get() {
        return (SyncopeConsoleSession)Session.get();
    }

    public SyncopeConsoleSession(Request request) {
        super(request);
        this.clientFactory = SyncopeConsoleApplication.get().newClientFactory();
        this.anonymousClient = this.clientFactory.create((AuthenticationHandler)new AnonymousAuthenticationHandler(SyncopeConsoleApplication.get().getAnonymousUser(), SyncopeConsoleApplication.get().getAnonymousKey()));
        this.platformInfo = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).platform();
        this.systemInfo = ((SyncopeService)this.anonymousClient.getService(SyncopeService.class)).system();
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setWaitForTasksToCompleteOnShutdown(false);
        this.executor.setCorePoolSize(SyncopeConsoleApplication.get().getCorePoolSize().intValue());
        this.executor.setMaxPoolSize(SyncopeConsoleApplication.get().getMaxPoolSize().intValue());
        this.executor.setQueueCapacity(SyncopeConsoleApplication.get().getQueueCapacity().intValue());
        this.executor.initialize();
    }

    protected String message(SyncopeClientException sce) {
        return sce.getType().name() + ": " + sce.getElements().stream().collect(Collectors.joining(", "));
    }

    public void onException(Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        String message = root.getMessage();
        if (root instanceof SyncopeClientException) {
            SyncopeClientException sce = (SyncopeClientException)root;
            message = sce.isComposite() ? sce.asComposite().getExceptions().stream().map(this::message).collect(Collectors.joining("; ")) : this.message(sce);
        } else if (root instanceof AccessControlException || root instanceof ForbiddenException) {
            Error error = StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"expired") ? Error.SESSION_EXPIRED : Error.AUTHORIZATION;
            message = this.getApplication().getResourceSettings().getLocalizer().getString(error.key(), null, null, null, null, error.fallback());
        } else if (root instanceof BadRequestException || root instanceof WebServiceException) {
            message = this.getApplication().getResourceSettings().getLocalizer().getString(Error.REST.key(), null, null, null, null, Error.REST.fallback());
        }
        message = this.getApplication().getResourceSettings().getLocalizer().getString(message, null, null, null, null, message);
        this.error((Serializable)((Object)message));
    }

    public MediaType getMediaType() {
        return this.clientFactory.getContentType().getMediaType();
    }

    public SyncopeClient getAnonymousClient() {
        return this.anonymousClient;
    }

    public void execute(Runnable command) {
        try {
            this.executor.execute(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", (Object)command, (Object)e);
        }
    }

    public <T> Future<T> execute(Callable<T> command) {
        try {
            return this.executor.submit(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", command, (Object)e);
            return new CompletableFuture();
        }
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return StringUtils.isBlank((CharSequence)this.domain) ? "Master" : this.domain;
    }

    public String getJWT() {
        return this.client == null ? null : this.client.getJWT();
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(username, password);
            this.refreshAuth(username);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(jwt);
            this.refreshAuth(null);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        if (authenticated) {
            this.bind();
        }
        this.signIn(authenticated);
        return authenticated;
    }

    public void cleanup() {
        this.client = null;
        this.auth = null;
        this.selfTO = null;
        this.services.clear();
    }

    public void invalidate() {
        if (this.getJWT() != null) {
            if (this.client != null) {
                this.client.logout();
            }
            this.cleanup();
        }
        this.executor.shutdown();
        super.invalidate();
    }

    public UserTO getSelfTO() {
        return this.selfTO;
    }

    public List<String> getAuthRealms() {
        return this.auth.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    public List<String> getSearchableRealms() {
        Set<String> roots = this.auth.get("REALM_LIST");
        return roots.isEmpty() ? Collections.emptyList() : roots.stream().sorted().collect(Collectors.toList());
    }

    public Optional<String> getRootRealm() {
        List<String> roots = this.getSearchableRealms();
        return roots.isEmpty() ? Optional.empty() : roots.stream().findFirst();
    }

    public boolean owns(String entitlements, String ... realms) {
        if (StringUtils.isEmpty((CharSequence)entitlements)) {
            return true;
        }
        if (this.auth == null) {
            return false;
        }
        HashSet<String> requested = ArrayUtils.isEmpty((Object[])realms) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(realms));
        for (String entitlement : entitlements.split(",")) {
            if (!this.auth.containsKey(entitlement)) continue;
            boolean owns = false;
            Set<String> owned = this.auth.get(entitlement);
            if (requested.isEmpty()) {
                return !owned.isEmpty();
            }
            for (String realm : requested) {
                if (realm.startsWith("/")) {
                    owns |= owned.stream().anyMatch(ownedRealm -> realm.startsWith((String)ownedRealm));
                    continue;
                }
                owns |= owned.contains(realm);
            }
            return owns;
        }
        return false;
    }

    public Roles getRoles() {
        if (this.isSignedIn() && this.roles == null && this.auth != null) {
            this.roles = new Roles(this.auth.keySet().toArray(new String[0]));
            this.roles.add((Object)"AUTHENTICATED");
        }
        return this.roles;
    }

    public void refreshAuth(String username) {
        try {
            Pair self = this.client.self();
            this.auth = (Map)self.getLeft();
            this.selfTO = (UserTO)self.getRight();
            this.roles = null;
        }
        catch (ForbiddenException e) {
            LOG.warn("Could not read self(), probably in a {} scenario", (Object)"MUST_CHANGE_PASSWORD", (Object)e);
            this.selfTO = new UserTO();
            this.selfTO.setUsername(username);
            this.selfTO.setMustChangePassword(true);
        }
    }

    protected <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        WebClient.client((Object)service).type("application/json").accept(new String[]{"application/json"});
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.getCachedService(serviceClass);
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getCachedService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false);
        return serviceInstance;
    }

    public BatchRequest batch() {
        return this.client.batch();
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    public FastDateFormat getDateFormat() {
        return FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)this.getLocale());
    }

    public static enum Error {
        SESSION_EXPIRED("error.session.expired", "Session expired: please login again"),
        AUTHORIZATION("error.authorization", "Insufficient access rights when performing the requested operation"),
        REST("error.rest", "There was an error while contacting the Core server");

        private final String key;
        private final String fallback;

        private Error(String key, String fallback) {
            this.key = key;
            this.fallback = fallback;
        }

        public String key() {
            return this.key;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

