/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl.persistence.entity;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import org.flowable.batch.service.impl.persistence.entity.AbstractBatchServiceEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;

public class BatchEntityImpl
extends AbstractBatchServiceEntity
implements BatchEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String BATCH_DOCUMENT_JSON_LABEL = "batchDocumentJson";
    protected String batchType;
    protected Date createTime;
    protected Date completeTime;
    protected String batchSearchKey;
    protected String batchSearchKey2;
    protected String status;
    protected ByteArrayRef batchDocRefId;
    protected String tenantId;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("batchType", this.batchType);
        persistentState.put("createTime", this.createTime);
        persistentState.put("completeTime", this.completeTime);
        persistentState.put("batchSearchKey", this.batchSearchKey);
        persistentState.put("batchSearchKey2", this.batchSearchKey2);
        persistentState.put("status", this.status);
        persistentState.put("tenantId", this.tenantId);
        if (this.batchDocRefId != null) {
            persistentState.put("batchDocRefId", this.batchDocRefId);
        }
        return persistentState;
    }

    public String getBatchType() {
        return this.batchType;
    }

    @Override
    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date time) {
        this.createTime = time;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }

    public String getBatchSearchKey() {
        return this.batchSearchKey;
    }

    @Override
    public void setBatchSearchKey(String batchSearchKey) {
        this.batchSearchKey = batchSearchKey;
    }

    public String getBatchSearchKey2() {
        return this.batchSearchKey2;
    }

    @Override
    public void setBatchSearchKey2(String batchSearchKey2) {
        this.batchSearchKey2 = batchSearchKey2;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public ByteArrayRef getBatchDocRefId() {
        return this.batchDocRefId;
    }

    public void setBatchDocRefId(ByteArrayRef batchDocRefId) {
        this.batchDocRefId = batchDocRefId;
    }

    public String getBatchDocumentJson(String engineType) {
        byte[] bytes;
        if (this.batchDocRefId != null && (bytes = this.batchDocRefId.getBytes(engineType)) != null) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void setBatchDocumentJson(String batchDocumentJson, String engineType) {
        this.batchDocRefId = BatchEntityImpl.setByteArrayRef(this.batchDocRefId, BATCH_DOCUMENT_JSON_LABEL, batchDocumentJson, engineType);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    protected static ByteArrayRef setByteArrayRef(ByteArrayRef byteArrayRef, String name, String value, String engineType) {
        if (byteArrayRef == null) {
            byteArrayRef = new ByteArrayRef();
        }
        byte[] bytes = null;
        if (value != null) {
            bytes = value.getBytes(StandardCharsets.UTF_8);
        }
        byteArrayRef.setValue(name, bytes, engineType);
        return byteArrayRef;
    }
}

