/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.schema;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.LdapConnector;
import net.tirasa.connid.bundles.ldap.commons.LdapAttributeType;
import net.tirasa.connid.bundles.ldap.commons.LdapNativeSchema;
import net.tirasa.connid.bundles.ldap.commons.ObjectClassMappingConfig;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.SyncOp;

class LdapSchemaBuilder {
    private static final Log log = Log.getLog(LdapSchemaBuilder.class);
    private final LdapConnection conn;
    private final LdapNativeSchema nativeSchema;
    private Schema schema;

    public LdapSchemaBuilder(LdapConnection conn) {
        this.conn = conn;
        this.nativeSchema = conn.createNativeSchema();
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    private void buildSchema() {
        SchemaBuilder schemaBld = new SchemaBuilder(LdapConnector.class);
        for (ObjectClassMappingConfig oclassConfig : this.conn.getConfiguration().getObjectClassMappingConfigs().values()) {
            ObjectClass oclass = oclassConfig.getObjectClass();
            ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
            objClassBld.setType(oclass.getObjectClassValue());
            objClassBld.setContainer(oclassConfig.isContainer());
            objClassBld.addAllAttributeInfo(this.createAttributeInfos(oclassConfig.getLdapClasses()));
            objClassBld.addAllAttributeInfo(oclassConfig.getOperationalAttributes());
            ObjectClassInfo oci = objClassBld.build();
            schemaBld.defineObjectClass(oci);
            if (!oci.is(ObjectClass.ACCOUNT_NAME)) {
                schemaBld.removeSupportedObjectClass(AuthenticateOp.class, oci);
            }
            if (this.conn.getServerType() != LdapConnection.ServerType.OPENDJ) continue;
            schemaBld.removeSupportedObjectClass(SyncOp.class, oci);
        }
        for (String ldapClass : this.nativeSchema.getStructuralObjectClasses()) {
            ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
            objClassBld.setType(ldapClass);
            objClassBld.setContainer(true);
            objClassBld.addAllAttributeInfo(this.createAttributeInfos(this.nativeSchema.getEffectiveObjectClasses(ldapClass)));
            ObjectClassInfo oci = objClassBld.build();
            schemaBld.defineObjectClass(oci);
            schemaBld.removeSupportedObjectClass(AuthenticateOp.class, oci);
            if (this.conn.getServerType() != LdapConnection.ServerType.OPENDJ) continue;
            schemaBld.removeSupportedObjectClass(SyncOp.class, oci);
        }
        this.schema = schemaBld.build();
    }

    private Set<AttributeInfo> createAttributeInfos(Collection<String> ldapClasses) {
        HashSet<AttributeInfo> result = new HashSet<AttributeInfo>();
        Set<String> requiredAttrs = this.getRequiredAttributes(ldapClasses);
        Set<String> optionalAttrs = this.getOptionalAttributes(ldapClasses);
        optionalAttrs.removeAll(requiredAttrs);
        this.addAttributeInfos(ldapClasses, requiredAttrs, EnumSet.of(AttributeInfo.Flags.REQUIRED), null, result);
        this.addAttributeInfos(ldapClasses, optionalAttrs, null, null, result);
        return result;
    }

    private Set<String> getRequiredAttributes(Collection<String> ldapClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String ldapClass : ldapClasses) {
            result.addAll(this.nativeSchema.getRequiredAttributes(ldapClass));
        }
        return result;
    }

    private Set<String> getOptionalAttributes(Collection<String> ldapClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String ldapClass : ldapClasses) {
            result.addAll(this.nativeSchema.getOptionalAttributes(ldapClass));
        }
        return result;
    }

    private void addAttributeInfos(Collection<String> ldapClasses, Set<String> attrs, Set<AttributeInfo.Flags> add, Set<AttributeInfo.Flags> remove, Set<AttributeInfo> toSet) {
        for (String attr : attrs) {
            this.addAttributeInfo(ldapClasses, attr, attr, add, remove, toSet);
        }
    }

    private void addAttributeInfo(Collection<String> ldapClasses, String ldapAttrName, String realName, Set<AttributeInfo.Flags> add, Set<AttributeInfo.Flags> remove, Set<AttributeInfo> toSet) {
        LdapAttributeType attrDesc = this.nativeSchema.getAttributeDescription(ldapAttrName);
        if (attrDesc != null) {
            toSet.add(attrDesc.createAttributeInfo(realName, add, remove));
        } else {
            log.warn("Could not find attribute {0} in object classes {1}", new Object[]{ldapAttrName, ldapClasses});
        }
    }
}

