/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.ObjectClassMappingConfig;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.EqualsHashCodeBuilder;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SyncOp;

public class LdapConfiguration
extends AbstractConfiguration {
    public static final int DEFAULT_PORT = 389;
    private String host;
    private int port = 389;
    private boolean ssl;
    private String[] failover = new String[0];
    private String principal;
    private GuardedString credentials;
    private String[] baseContexts = new String[0];
    private String passwordAttribute = "userPassword";
    private String accountSearchFilter = null;
    private String groupSearchFilter = null;
    private String groupMemberAttribute = "uniqueMember";
    private boolean maintainLdapGroupMembership = false;
    private boolean maintainPosixGroupMembership = false;
    private String passwordHashAlgorithm;
    private boolean respectResourcePasswordPolicyChangeAfterReset;
    private boolean useVlvControls = false;
    private String vlvSortAttribute = "uid";
    private String uidAttribute = "entryUUID";
    private String gidAttribute = "entryUUID";
    private String defaultIdAttribute = "entryUUID";
    private boolean readSchema = true;
    private String[] baseContextsToSynchronize = new String[0];
    private String[] objectClassesToSynchronize = new String[]{"inetOrgPerson"};
    private String[] attributesToSynchronize = new String[0];
    private String[] modifiersNamesToFilterOut = new String[0];
    private String accountSynchronizationFilter;
    private int changeLogBlockSize = 100;
    private String changeNumberAttribute = "changeNumber";
    private boolean filterWithOrInsteadOfAnd;
    private boolean removeLogEntryObjectClassFromFilter = true;
    private boolean synchronizePasswords;
    private String passwordAttributeToSynchronize;
    private GuardedByteArray passwordDecryptionKey;
    private GuardedByteArray passwordDecryptionInitializationVector;
    private String statusManagementClass;
    private String dnAttribute = "entryDN";
    private boolean retrievePasswordsWithSearch;
    private final ObjectClassMappingConfig accountConfig = new ObjectClassMappingConfig(ObjectClass.ACCOUNT, CollectionUtil.newList((Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}), false, CollectionUtil.newList((Object[])new String[]{"uid", "cn"}), LdapConstants.PASSWORD);
    private final ObjectClassMappingConfig groupConfig = new ObjectClassMappingConfig(ObjectClass.GROUP, CollectionUtil.newList((Object[])new String[]{"top", "groupOfUniqueNames"}), false, CollectionUtil.newList((Object[])new String[]{"cn"}), new AttributeInfo[0]);
    private final ObjectClassMappingConfig allConfig = new ObjectClassMappingConfig(ObjectClass.ALL, CollectionUtil.newList((Object[])new String[]{"top"}), false, CollectionUtil.newList((Object[])new String[]{this.defaultIdAttribute}), new AttributeInfo[0]);
    private List<LdapName> baseContextsAsLdapNames;
    private List<LdapName> baseContextsToSynchronizeAsLdapNames;
    private Set<LdapName> modifiersNamesToFilterOutAsLdapNames;
    private long readTimeout = 0L;
    private long connectTimeout = 0L;

    public void validate() {
        this.checkNotBlank(this.host, "host.notBlank");
        if (this.port < 0 || this.port > 65535) {
            this.failValidation("port.legalValue", new Object[0]);
        }
        this.checkNotEmpty(this.baseContexts, "baseContexts.notEmpty");
        this.checkNoBlankValues(this.baseContexts, "baseContexts.noBlankValues");
        this.checkNoInvalidLdapNames(this.baseContexts, "baseContexts.noInvalidLdapNames");
        this.checkNotBlank(this.passwordAttribute, "passwordAttribute.notBlank");
        this.checkNotEmpty(this.accountConfig.getLdapClasses(), "accountObjectClasses.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getLdapClasses(), "accountObjectClasses.noBlankValues");
        this.checkNotEmpty(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getLdapClasses(), "groupObjectClasses.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getLdapClasses(), "groupObjectClasses.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getShortNameLdapAttributes(), "groupNameAttributes.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getShortNameLdapAttributes(), "groupNameAttributes.noBlankValues");
        this.checkNotBlank(this.groupMemberAttribute, "groupMemberAttribute.notBlank");
        this.checkNotBlank(this.vlvSortAttribute, "vlvSortAttribute.notBlank");
        if (this.baseContextsToSynchronize != null) {
            this.checkNoBlankValues(this.baseContextsToSynchronize, "baseContextsToSynchronize.noBlankValues");
            this.checkNoInvalidLdapNames(this.baseContextsToSynchronize, "baseContextsToSynchronize.noInvalidLdapNames");
        }
        this.checkNotEmpty(this.objectClassesToSynchronize, "objectClassesToSynchronize.notEmpty");
        this.checkNoBlankValues(this.objectClassesToSynchronize, "objectClassesToSynchronize.noBlankValues");
        if (this.attributesToSynchronize != null) {
            this.checkNoBlankValues(this.attributesToSynchronize, "attributesToSynchronize.noBlankValues");
        }
        if (this.modifiersNamesToFilterOut != null) {
            this.checkNoBlankValues(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noBlankValues");
            this.checkNoInvalidLdapNames(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noInvalidLdapNames");
        }
        this.checkNotBlank(this.changeNumberAttribute, "changeNumberAttribute.notBlank");
        if (this.changeLogBlockSize <= 0) {
            this.failValidation("changeLogBlockSize.legalValue", new Object[0]);
        }
        if (this.synchronizePasswords) {
            this.checkNotBlank(this.passwordAttributeToSynchronize, "passwordAttributeToSynchronize.notBlank");
            this.checkNotBlank(this.passwordDecryptionKey, "decryptionKey.notBlank");
            this.checkNotBlank(this.passwordDecryptionInitializationVector, "decryptionInitializationVector.notBlank");
        }
    }

    private void checkNotBlank(String value, String errorMessage) {
        if (StringUtil.isBlank((String)value)) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotBlank(GuardedByteArray array, String errorMessage) {
        final int[] length = new int[]{0};
        if (array != null) {
            array.access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    length[0] = clearBytes.length;
                }
            });
        }
        if (length[0] == 0) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(Collection<?> collection, String errorMessage) {
        if (collection.size() < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(String[] array, String errorMessage) {
        if (array == null || array.length < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(Collection<String> collection, String errorMessage) {
        for (String each : collection) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(String[] array, String errorMessage) {
        for (String each : array) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoInvalidLdapNames(String[] array, String errorMessage) {
        for (String each : array) {
            try {
                new LdapName(each);
            }
            catch (InvalidNameException e) {
                this.failValidation(errorMessage, each);
            }
        }
    }

    private void failValidation(String key, Object ... args) {
        String message = this.getConnectorMessages().format(key, null, args);
        throw new ConfigurationException(message);
    }

    public DefaultSearchStrategy newDefaultSearchStrategy(boolean ignoreNonExistingBaseDN) {
        return new DefaultSearchStrategy(ignoreNonExistingBaseDN);
    }

    @ConfigurationProperty(order=1, required=true, displayMessageKey="host.display", helpMessageKey="host.help")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @ConfigurationProperty(order=2, displayMessageKey="port.display", helpMessageKey="port.help")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ConfigurationProperty(order=3, displayMessageKey="ssl.display", helpMessageKey="ssl.help")
    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @ConfigurationProperty(order=4, displayMessageKey="failover.display", helpMessageKey="failover.help")
    public String[] getFailover() {
        return (String[])this.failover.clone();
    }

    public void setFailover(String ... failover) {
        this.failover = failover;
    }

    @ConfigurationProperty(order=5, displayMessageKey="principal.display", helpMessageKey="principal.help")
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @ConfigurationProperty(order=6, confidential=true, displayMessageKey="credentials.display", helpMessageKey="credentials.help")
    public GuardedString getCredentials() {
        return this.credentials;
    }

    public void setCredentials(GuardedString credentials) {
        this.credentials = credentials != null ? credentials.copy() : null;
    }

    @ConfigurationProperty(order=7, required=true, displayMessageKey="baseContexts.display", helpMessageKey="baseContexts.help")
    public String[] getBaseContexts() {
        return (String[])this.baseContexts.clone();
    }

    public void setBaseContexts(String ... baseContexts) {
        this.baseContexts = (String[])baseContexts.clone();
    }

    @ConfigurationProperty(order=8, displayMessageKey="passwordAttribute.display", helpMessageKey="passwordAttribute.help")
    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @ConfigurationProperty(order=9, displayMessageKey="accountObjectClasses.display", helpMessageKey="accountObjectClasses.help")
    public String[] getAccountObjectClasses() {
        List<String> ldapClasses = this.accountConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setAccountObjectClasses(String ... accountObjectClasses) {
        this.accountConfig.setLdapClasses(Arrays.asList(accountObjectClasses));
    }

    @ConfigurationProperty(order=10, displayMessageKey="accountUserNameAttributes.display", helpMessageKey="accountUserNameAttributes.help")
    public String[] getAccountUserNameAttributes() {
        List<String> shortNameLdapAttributes = this.accountConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setAccountUserNameAttributes(String ... accountUserNameAttributes) {
        this.accountConfig.setShortNameLdapAttributes(Arrays.asList(accountUserNameAttributes));
    }

    @ConfigurationProperty(order=11, displayMessageKey="accountSearchFilter.display", helpMessageKey="accountSearchFilter.help")
    public String getAccountSearchFilter() {
        return this.accountSearchFilter;
    }

    public void setAccountSearchFilter(String accountSearchFilter) {
        this.accountSearchFilter = accountSearchFilter;
    }

    @ConfigurationProperty(order=12, displayMessageKey="groupObjectClasses.display", helpMessageKey="groupObjectClasses.help")
    public String[] getGroupObjectClasses() {
        List<String> ldapClasses = this.groupConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setGroupObjectClasses(String ... groupObjectClasses) {
        this.groupConfig.setLdapClasses(Arrays.asList(groupObjectClasses));
    }

    @ConfigurationProperty(order=13, displayMessageKey="groupNameAttributes.display", helpMessageKey="groupNameAttributes.help")
    public String[] getGroupNameAttributes() {
        List<String> shortNameLdapAttributes = this.groupConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setGroupNameAttributes(String ... groupNameAttributes) {
        this.groupConfig.setShortNameLdapAttributes(Arrays.asList(groupNameAttributes));
    }

    @ConfigurationProperty(order=14, displayMessageKey="groupMemberAttribute.display", helpMessageKey="groupMemberAttribute.help")
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    @ConfigurationProperty(order=15, displayMessageKey="maintainLdapGroupMembership.display", helpMessageKey="maintainLdapGroupMembership.help")
    public boolean isMaintainLdapGroupMembership() {
        return this.maintainLdapGroupMembership;
    }

    public void setMaintainLdapGroupMembership(boolean maintainLdapGroupMembership) {
        this.maintainLdapGroupMembership = maintainLdapGroupMembership;
    }

    @ConfigurationProperty(order=16, displayMessageKey="maintainPosixGroupMembership.display", helpMessageKey="maintainPosixGroupMembership.help")
    public boolean isMaintainPosixGroupMembership() {
        return this.maintainPosixGroupMembership;
    }

    public void setMaintainPosixGroupMembership(boolean maintainPosixGroupMembership) {
        this.maintainPosixGroupMembership = maintainPosixGroupMembership;
    }

    @ConfigurationProperty(order=17, displayMessageKey="passwordHashAlgorithm.display", helpMessageKey="passwordHashAlgorithm.help")
    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        this.passwordHashAlgorithm = passwordHashAlgorithm;
    }

    @ConfigurationProperty(order=18, displayMessageKey="respectResourcePasswordPolicyChangeAfterReset.display", helpMessageKey="respectResourcePasswordPolicyChangeAfterReset.help")
    public boolean isRespectResourcePasswordPolicyChangeAfterReset() {
        return this.respectResourcePasswordPolicyChangeAfterReset;
    }

    public void setRespectResourcePasswordPolicyChangeAfterReset(boolean respectResourcePasswordPolicyChangeAfterReset) {
        this.respectResourcePasswordPolicyChangeAfterReset = respectResourcePasswordPolicyChangeAfterReset;
    }

    @ConfigurationProperty(order=19, displayMessageKey="useVlvControls.display", helpMessageKey="useVlvControls.help")
    public boolean isUseVlvControls() {
        return this.useVlvControls;
    }

    public void setUseVlvControls(boolean useVlvControls) {
        this.useVlvControls = useVlvControls;
    }

    @ConfigurationProperty(order=20, displayMessageKey="vlvSortAttribute.display", helpMessageKey="vlvSortAttribute.help")
    public String getVlvSortAttribute() {
        return this.vlvSortAttribute;
    }

    public void setVlvSortAttribute(String vlvSortAttribute) {
        this.vlvSortAttribute = vlvSortAttribute;
    }

    @ConfigurationProperty(order=21, displayMessageKey="uidAttribute.display", helpMessageKey="uidAttribute.help")
    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    @ConfigurationProperty(order=22, displayMessageKey="gidAttribute.display", helpMessageKey="gidAttribute.help")
    public String getGidAttribute() {
        return this.gidAttribute;
    }

    public void setGidAttribute(String gidAttribute) {
        this.gidAttribute = gidAttribute;
    }

    @ConfigurationProperty(order=23, displayMessageKey="readSchema.display", helpMessageKey="readSchema.help")
    public boolean isReadSchema() {
        return this.readSchema;
    }

    public void setReadSchema(boolean readSchema) {
        this.readSchema = readSchema;
    }

    @ConfigurationProperty(order=24, operations={SyncOp.class}, displayMessageKey="baseContextsToSynchronize.display", helpMessageKey="baseContextsToSynchronize.help")
    public String[] getBaseContextsToSynchronize() {
        return (String[])this.baseContextsToSynchronize.clone();
    }

    public void setBaseContextsToSynchronize(String ... baseContextsToSynchronize) {
        this.baseContextsToSynchronize = (String[])baseContextsToSynchronize.clone();
    }

    @ConfigurationProperty(order=25, operations={SyncOp.class}, displayMessageKey="objectClassesToSynchronize.display", helpMessageKey="objectClassesToSynchronize.help")
    public String[] getObjectClassesToSynchronize() {
        return (String[])this.objectClassesToSynchronize.clone();
    }

    public void setObjectClassesToSynchronize(String ... objectClassesToSynchronize) {
        this.objectClassesToSynchronize = (String[])objectClassesToSynchronize.clone();
    }

    @ConfigurationProperty(order=26, operations={SyncOp.class}, displayMessageKey="attributesToSynchronize.display", helpMessageKey="attributesToSynchronize.help")
    public String[] getAttributesToSynchronize() {
        return (String[])this.attributesToSynchronize.clone();
    }

    public void setAttributesToSynchronize(String ... attributesToSynchronize) {
        this.attributesToSynchronize = (String[])attributesToSynchronize.clone();
    }

    @ConfigurationProperty(order=27, operations={SyncOp.class}, displayMessageKey="modifiersNamesToFilterOut.display", helpMessageKey="modifiersNamesToFilterOut.help")
    public String[] getModifiersNamesToFilterOut() {
        return (String[])this.modifiersNamesToFilterOut.clone();
    }

    public void setModifiersNamesToFilterOut(String ... modifiersNamesToFilterOut) {
        this.modifiersNamesToFilterOut = (String[])modifiersNamesToFilterOut.clone();
    }

    @ConfigurationProperty(order=28, operations={SyncOp.class}, displayMessageKey="accountSynchronizationFilter.display", helpMessageKey="accountSynchronizationFilter.help")
    public String getAccountSynchronizationFilter() {
        return this.accountSynchronizationFilter;
    }

    public void setAccountSynchronizationFilter(String accountSynchronizationFilter) {
        this.accountSynchronizationFilter = accountSynchronizationFilter;
    }

    @ConfigurationProperty(order=29, operations={SyncOp.class}, displayMessageKey="changeLogBlockSize.display", helpMessageKey="changeLogBlockSize.help")
    public int getChangeLogBlockSize() {
        return this.changeLogBlockSize;
    }

    public void setChangeLogBlockSize(int changeLogBlockSize) {
        this.changeLogBlockSize = changeLogBlockSize;
    }

    @ConfigurationProperty(order=30, operations={SyncOp.class}, displayMessageKey="changeNumberAttribute.display", helpMessageKey="changeNumberAttribute.help")
    public String getChangeNumberAttribute() {
        return this.changeNumberAttribute;
    }

    public void setChangeNumberAttribute(String changeNumberAttribute) {
        this.changeNumberAttribute = changeNumberAttribute;
    }

    @ConfigurationProperty(order=31, operations={SyncOp.class}, displayMessageKey="filterWithOrInsteadOfAnd.display", helpMessageKey="filterWithOrInsteadOfAnd.help")
    public boolean isFilterWithOrInsteadOfAnd() {
        return this.filterWithOrInsteadOfAnd;
    }

    public void setFilterWithOrInsteadOfAnd(boolean filterWithOrInsteadOfAnd) {
        this.filterWithOrInsteadOfAnd = filterWithOrInsteadOfAnd;
    }

    @ConfigurationProperty(order=32, operations={SyncOp.class}, displayMessageKey="removeLogEntryObjectClassFromFilter.display", helpMessageKey="removeLogEntryObjectClassFromFilter.help")
    public boolean isRemoveLogEntryObjectClassFromFilter() {
        return this.removeLogEntryObjectClassFromFilter;
    }

    public void setRemoveLogEntryObjectClassFromFilter(boolean removeLogEntryObjectClassFromFilter) {
        this.removeLogEntryObjectClassFromFilter = removeLogEntryObjectClassFromFilter;
    }

    @ConfigurationProperty(order=33, operations={SyncOp.class}, displayMessageKey="synchronizePasswords.display", helpMessageKey="synchronizePasswords.help")
    public boolean isSynchronizePasswords() {
        return this.synchronizePasswords;
    }

    public void setSynchronizePasswords(boolean synchronizePasswords) {
        this.synchronizePasswords = synchronizePasswords;
    }

    @ConfigurationProperty(order=34, operations={SyncOp.class}, displayMessageKey="passwordAttributeToSynchronize.display", helpMessageKey="passwordAttributeToSynchronize.help")
    public String getPasswordAttributeToSynchronize() {
        return this.passwordAttributeToSynchronize;
    }

    public void setPasswordAttributeToSynchronize(String passwordAttributeToSynchronize) {
        this.passwordAttributeToSynchronize = passwordAttributeToSynchronize;
    }

    @ConfigurationProperty(order=35, operations={SyncOp.class}, confidential=true, displayMessageKey="passwordDecryptionKey.display", helpMessageKey="passwordDecryptionKey.help")
    public GuardedByteArray getPasswordDecryptionKey() {
        return this.passwordDecryptionKey;
    }

    public void setPasswordDecryptionKey(GuardedByteArray passwordDecryptionKey) {
        this.passwordDecryptionKey = passwordDecryptionKey != null ? passwordDecryptionKey.copy() : null;
    }

    @ConfigurationProperty(order=36, operations={SyncOp.class}, confidential=true, displayMessageKey="passwordDecryptionInitializationVector.display", helpMessageKey="passwordDecryptionInitializationVector.help")
    public GuardedByteArray getPasswordDecryptionInitializationVector() {
        return this.passwordDecryptionInitializationVector;
    }

    public void setPasswordDecryptionInitializationVector(GuardedByteArray passwordDecryptionInitializationVector) {
        this.passwordDecryptionInitializationVector = passwordDecryptionInitializationVector != null ? passwordDecryptionInitializationVector.copy() : null;
    }

    @ConfigurationProperty(order=37, displayMessageKey="statusManagementClass.display", helpMessageKey="statusManagementClass.help")
    public String getStatusManagementClass() {
        return this.statusManagementClass;
    }

    public void setStatusManagementClass(String statusManagementClass) {
        this.statusManagementClass = statusManagementClass;
    }

    @ConfigurationProperty(order=38, displayMessageKey="retrievePasswordsWithSearch.display", helpMessageKey="retrievePasswordsWithSearch.help")
    public boolean getRetrievePasswordsWithSearch() {
        return this.retrievePasswordsWithSearch;
    }

    public void setRetrievePasswordsWithSearch(boolean retrievePasswordsWithSearch) {
        this.retrievePasswordsWithSearch = retrievePasswordsWithSearch;
    }

    @ConfigurationProperty(order=39, displayMessageKey="dnAttribute.display", helpMessageKey="dnAttribute.help")
    public String getDnAttribute() {
        return this.dnAttribute;
    }

    public void setDnAttribute(String dnAttribute) {
        this.dnAttribute = dnAttribute;
    }

    @ConfigurationProperty(order=40, displayMessageKey="groupSearchFilter.display", helpMessageKey="groupSearchFilter.help")
    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    @ConfigurationProperty(order=41, displayMessageKey="readTimeout.display", helpMessageKey="readTimeout.help")
    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    @ConfigurationProperty(order=42, displayMessageKey="connectTimeout.display", helpMessageKey="connectTimeout.help")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public List<LdapName> getBaseContextsAsLdapNames() {
        if (this.baseContextsAsLdapNames == null) {
            ArrayList<LdapName> result = new ArrayList<LdapName>(this.baseContexts.length);
            try {
                for (String baseContext : this.baseContexts) {
                    result.add(new LdapName(baseContext));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsAsLdapNames = result;
        }
        return this.baseContextsAsLdapNames;
    }

    public List<LdapName> getBaseContextsToSynchronizeAsLdapNames() {
        if (this.baseContextsToSynchronizeAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.baseContextsToSynchronize);
            ArrayList<LdapName> result = new ArrayList<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsToSynchronizeAsLdapNames = result;
        }
        return this.baseContextsToSynchronizeAsLdapNames;
    }

    public Set<LdapName> getModifiersNamesToFilterOutAsLdapNames() {
        if (this.modifiersNamesToFilterOutAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.modifiersNamesToFilterOut);
            HashSet<LdapName> result = new HashSet<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.modifiersNamesToFilterOutAsLdapNames = result;
        }
        return this.modifiersNamesToFilterOutAsLdapNames;
    }

    public Map<ObjectClass, ObjectClassMappingConfig> getObjectClassMappingConfigs() {
        HashMap<ObjectClass, ObjectClassMappingConfig> result = new HashMap<ObjectClass, ObjectClassMappingConfig>();
        result.put(this.accountConfig.getObjectClass(), this.accountConfig);
        result.put(this.groupConfig.getObjectClass(), this.groupConfig);
        result.put(this.allConfig.getObjectClass(), this.allConfig);
        return result;
    }

    private EqualsHashCodeBuilder createHashCodeBuilder() {
        EqualsHashCodeBuilder builder = new EqualsHashCodeBuilder();
        builder.append((Object)this.host);
        builder.append((Object)this.port);
        builder.append((Object)this.ssl);
        builder.append((Object)this.failover);
        builder.append((Object)this.principal);
        builder.append((Object)this.credentials);
        for (String baseContext : this.baseContexts) {
            builder.append((Object)baseContext);
        }
        builder.append((Object)this.passwordAttribute);
        builder.append((Object)this.accountSearchFilter);
        builder.append((Object)this.groupMemberAttribute);
        builder.append((Object)this.maintainLdapGroupMembership);
        builder.append((Object)this.maintainPosixGroupMembership);
        builder.append((Object)this.passwordHashAlgorithm);
        builder.append((Object)this.respectResourcePasswordPolicyChangeAfterReset);
        builder.append((Object)this.useVlvControls);
        builder.append((Object)this.vlvSortAttribute);
        builder.append((Object)this.readSchema);
        for (String baseContextToSynchronize : this.baseContextsToSynchronize) {
            builder.append((Object)baseContextToSynchronize);
        }
        for (String objectClassToSynchronize : this.objectClassesToSynchronize) {
            builder.append((Object)objectClassToSynchronize);
        }
        for (String attributeToSynchronize : this.attributesToSynchronize) {
            builder.append((Object)attributeToSynchronize);
        }
        for (String modifiersNameToFilterOut : this.modifiersNamesToFilterOut) {
            builder.append((Object)modifiersNameToFilterOut);
        }
        builder.append((Object)this.accountSynchronizationFilter);
        builder.append((Object)this.changeLogBlockSize);
        builder.append((Object)this.changeNumberAttribute);
        builder.append((Object)this.filterWithOrInsteadOfAnd);
        builder.append((Object)this.removeLogEntryObjectClassFromFilter);
        builder.append((Object)this.synchronizePasswords);
        builder.append((Object)this.passwordAttributeToSynchronize);
        builder.append((Object)this.passwordDecryptionKey);
        builder.append((Object)this.passwordDecryptionInitializationVector);
        builder.append((Object)this.accountConfig);
        builder.append((Object)this.groupConfig);
        builder.append((Object)this.retrievePasswordsWithSearch);
        builder.append((Object)this.groupSearchFilter);
        builder.append((Object)this.connectTimeout);
        builder.append((Object)this.readTimeout);
        return builder;
    }

    public int hashCode() {
        return this.createHashCodeBuilder().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LdapConfiguration) {
            LdapConfiguration that = (LdapConfiguration)((Object)obj);
            if (this == that) {
                return true;
            }
            return this.createHashCodeBuilder().equals((Object)that.createHashCodeBuilder());
        }
        return false;
    }
}

