/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.api.entity.ReportTemplate;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.JPAReportExec;
import org.apache.syncope.core.persistence.jpa.entity.JPAReportTemplate;
import org.apache.syncope.core.persistence.jpa.validation.entity.ReportCheck;

@Entity
@Table(name="Report")
@ReportCheck
public class JPAReport
extends AbstractGeneratedKeyEntity
implements Report,
PersistenceCapable {
    private static final long serialVersionUID = -587652654964285834L;
    public static final String TABLE = "Report";
    @Column(unique=true, nullable=false)
    private String name;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ReportReportlet", joinColumns={@JoinColumn(name="report_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"report_id", "implementation_id"})})
    private List<JPAImplementation> reportlets = new ArrayList<JPAImplementation>();
    private String cronExpression;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="report")
    private List<JPAReportExec> executions = new ArrayList<JPAReportExec>();
    @NotNull
    private Boolean active = true;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="template_id")
    private JPAReportTemplate template;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReportTemplate;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport;

    public String getName() {
        return JPAReport.pcGetname(this);
    }

    public void setName(String name) {
        JPAReport.pcSetname(this, name);
    }

    public boolean add(ReportExec exec) {
        this.checkType(exec, JPAReportExec.class);
        return exec != null && !JPAReport.pcGetexecutions(this).contains((JPAReportExec)exec) && JPAReport.pcGetexecutions(this).add((JPAReportExec)exec);
    }

    public List<? extends ReportExec> getExecs() {
        return JPAReport.pcGetexecutions(this);
    }

    public boolean add(Implementation reportlet) {
        this.checkType(reportlet, JPAImplementation.class);
        this.checkImplementationType(reportlet, ImplementationType.REPORTLET);
        return JPAReport.pcGetreportlets(this).contains((JPAImplementation)reportlet) || JPAReport.pcGetreportlets(this).add((JPAImplementation)reportlet);
    }

    public List<? extends Implementation> getReportlets() {
        return JPAReport.pcGetreportlets(this);
    }

    public String getCronExpression() {
        return JPAReport.pcGetcronExpression(this);
    }

    public void setCronExpression(String cronExpression) {
        JPAReport.pcSetcronExpression(this, cronExpression);
    }

    public boolean isActive() {
        return JPAReport.pcGetactive(this);
    }

    public void setActive(boolean active) {
        JPAReport.pcSetactive(this, active);
    }

    public ReportTemplate getTemplate() {
        return JPAReport.pcGettemplate(this);
    }

    public void setTemplate(ReportTemplate template) {
        this.checkType(template, JPAReportTemplate.class);
        JPAReport.pcSettemplate(this, (JPAReportTemplate)template);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 121008823;
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = JPAReport.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"active", "cronExpression", "executions", "name", "reportlets", "template"};
        Class[] classArray = new Class[6];
        Class clazz2 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAReport.class$("java.lang.Boolean"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAReport.class$("java.lang.String"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAReport.class$("java.util.List"));
        classArray[2] = clazz4;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAReport.class$("java.lang.String"));
        classArray[4] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAReport.class$("java.util.List"));
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReportTemplate != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReportTemplate : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReportTemplate = JPAReport.class$("org.apache.syncope.core.persistence.jpa.entity.JPAReportTemplate"));
        classArray[5] = clazz5;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 10, 26};
        Class clazz6 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport = JPAReport.class$("org.apache.syncope.core.persistence.jpa.entity.JPAReport"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAReport", (PersistenceCapable)new JPAReport());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.active = null;
        this.cronExpression = null;
        this.executions = null;
        this.name = null;
        this.reportlets = null;
        this.template = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAReport jPAReport = new JPAReport();
        if (bl) {
            jPAReport.pcClearFields();
        }
        jPAReport.pcStateManager = stateManager;
        jPAReport.pcCopyKeyFieldsFromObjectId(object);
        return jPAReport;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAReport jPAReport = new JPAReport();
        if (bl) {
            jPAReport.pcClearFields();
        }
        jPAReport.pcStateManager = stateManager;
        return jPAReport;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.active = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.cronExpression = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.executions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.reportlets = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.template = (JPAReportTemplate)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.active);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.cronExpression);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.executions);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.reportlets);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.template);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAReport jPAReport, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAReport, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.active = jPAReport.active;
                return;
            }
            case 1: {
                this.cronExpression = jPAReport.cronExpression;
                return;
            }
            case 2: {
                this.executions = jPAReport.executions;
                return;
            }
            case 3: {
                this.name = jPAReport.name;
                return;
            }
            case 4: {
                this.reportlets = jPAReport.reportlets;
                return;
            }
            case 5: {
                this.template = jPAReport.template;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAReport jPAReport = (JPAReport)object;
        if (jPAReport.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAReport, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAReport = JPAReport.class$("org.apache.syncope.core.persistence.jpa.entity.JPAReport"));
        return clazz;
    }

    private static final Boolean pcGetactive(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.active;
        }
        int n = pcInheritedFieldCount + 0;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.active;
    }

    private static final void pcSetactive(JPAReport jPAReport, Boolean bl) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.active = bl;
            return;
        }
        jPAReport.pcStateManager.settingObjectField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 0, (Object)jPAReport.active, (Object)bl, 0);
    }

    private static final String pcGetcronExpression(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.cronExpression;
        }
        int n = pcInheritedFieldCount + 1;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.cronExpression;
    }

    private static final void pcSetcronExpression(JPAReport jPAReport, String string) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.cronExpression = string;
            return;
        }
        jPAReport.pcStateManager.settingStringField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 1, jPAReport.cronExpression, string, 0);
    }

    private static final List pcGetexecutions(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.executions;
        }
        int n = pcInheritedFieldCount + 2;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.executions;
    }

    private static final void pcSetexecutions(JPAReport jPAReport, List list) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.executions = list;
            return;
        }
        jPAReport.pcStateManager.settingObjectField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 2, jPAReport.executions, (Object)list, 0);
    }

    private static final String pcGetname(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.name;
        }
        int n = pcInheritedFieldCount + 3;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.name;
    }

    private static final void pcSetname(JPAReport jPAReport, String string) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.name = string;
            return;
        }
        jPAReport.pcStateManager.settingStringField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 3, jPAReport.name, string, 0);
    }

    private static final List pcGetreportlets(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.reportlets;
        }
        int n = pcInheritedFieldCount + 4;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.reportlets;
    }

    private static final void pcSetreportlets(JPAReport jPAReport, List list) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.reportlets = list;
            return;
        }
        jPAReport.pcStateManager.settingObjectField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 4, jPAReport.reportlets, (Object)list, 0);
    }

    private static final JPAReportTemplate pcGettemplate(JPAReport jPAReport) {
        if (jPAReport.pcStateManager == null) {
            return jPAReport.template;
        }
        int n = pcInheritedFieldCount + 5;
        jPAReport.pcStateManager.accessingField(n);
        return jPAReport.template;
    }

    private static final void pcSettemplate(JPAReport jPAReport, JPAReportTemplate jPAReportTemplate) {
        if (jPAReport.pcStateManager == null) {
            jPAReport.template = jPAReportTemplate;
            return;
        }
        jPAReport.pcStateManager.settingObjectField((PersistenceCapable)jPAReport, pcInheritedFieldCount + 5, (Object)jPAReport.template, (Object)jPAReportTemplate, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

