/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.JPATaskExec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPATaskExecDAO
extends AbstractDAO<TaskExec>
implements TaskExecDAO {
    @Autowired
    private TaskDAO taskDAO;

    public TaskExec find(String key) {
        return (TaskExec)this.entityManager().find(JPATaskExec.class, (Object)key);
    }

    public List<TaskExec> findRecent(int max) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATaskExec.class.getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC", TaskExec.class);
        query.setMaxResults(max);
        return query.getResultList();
    }

    private <T extends Task> TaskExec findLatest(T task, String field) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATaskExec.class.getSimpleName() + " e WHERE e.task=:task ORDER BY e." + field + " DESC", TaskExec.class);
        query.setParameter("task", task);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (TaskExec)result.iterator().next();
    }

    public <T extends Task> TaskExec findLatestStarted(T task) {
        return this.findLatest(task, "start");
    }

    public <T extends Task> TaskExec findLatestEnded(T task) {
        return this.findLatest(task, "end");
    }

    public <T extends Task> List<TaskExec> findAll(T task, Date startedBefore, Date startedAfter, Date endedBefore, Date endedAfter) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPATaskExec.class.getSimpleName()).append(" e WHERE e.task=:task ");
        if (startedBefore != null) {
            queryString.append(" AND e.start < :startedBefore");
        }
        if (startedAfter != null) {
            queryString.append(" AND e.start > :startedAfter");
        }
        if (endedBefore != null) {
            queryString.append(" AND e.end < :endedBefore");
        }
        if (endedAfter != null) {
            queryString.append(" AND e.end > :endedAfter");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), TaskExec.class);
        query.setParameter("task", task);
        if (startedBefore != null) {
            query.setParameter("startedBefore", (Object)startedBefore);
        }
        if (startedAfter != null) {
            query.setParameter("startedAfter", (Object)startedAfter);
        }
        if (endedBefore != null) {
            query.setParameter("endedBefore", (Object)endedBefore);
        }
        if (endedAfter != null) {
            query.setParameter("endedAfter", (Object)endedAfter);
        }
        return query.getResultList();
    }

    public int count(String taskKey) {
        Query countQuery = this.entityManager().createNativeQuery("SELECT COUNT(e.id) FROM TaskExec e WHERE e.task_id=?1");
        countQuery.setParameter(1, (Object)taskKey);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    private String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(JPATaskExec.class, (String)field) == null) continue;
            statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
        }
        if (statement.length() == 0) {
            statement.append("ORDER BY e.id DESC");
        } else {
            statement.insert(0, "ORDER BY ");
        }
        return statement.toString();
    }

    public <T extends Task> List<TaskExec> findAll(T task, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        String queryString = "SELECT e FROM " + JPATaskExec.class.getSimpleName() + " e WHERE e.task=:task " + this.toOrderByStatement(orderByClauses);
        TypedQuery query = this.entityManager().createQuery(queryString, TaskExec.class);
        query.setParameter("task", task);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public TaskExec save(TaskExec execution) {
        return (TaskExec)this.entityManager().merge((Object)execution);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveAndAdd(String taskKey, TaskExec execution) {
        Task task = this.taskDAO.find(taskKey);
        task.add(execution);
        this.taskDAO.save(task);
    }

    public void delete(String key) {
        TaskExec execution = this.find(key);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    public void delete(TaskExec execution) {
        if (execution.getTask() != null) {
            execution.getTask().getExecs().remove(execution);
        }
        this.entityManager().remove((Object)execution);
    }
}

