/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnyDAO;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAARelationship;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAURelationship;
import org.apache.syncope.core.provisioning.api.event.AnyCreatedUpdatedEvent;
import org.apache.syncope.core.provisioning.api.event.AnyDeletedEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JPAAnyObjectDAO
extends AbstractAnyDAO<AnyObject>
implements AnyObjectDAO {
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;

    @Override
    protected AnyUtils init() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
    }

    @Transactional(readOnly=true)
    public String findKey(String name) {
        return this.findKey(name, "AnyObject");
    }

    @Transactional(readOnly=true)
    public Date findLastChange(String key) {
        return this.findLastChange(key, "AnyObject");
    }

    public Map<AnyType, Integer> countByType() {
        Query query = this.entityManager().createQuery("SELECT e.type, COUNT(e) AS countByType FROM  " + this.anyUtils().anyClass().getSimpleName() + " e GROUP BY e.type ORDER BY countByType DESC");
        List results = query.getResultList();
        LinkedHashMap<AnyType, Integer> countByRealm = new LinkedHashMap<AnyType, Integer>(results.size());
        for (Object[] result : results) {
            countByRealm.put((AnyType)result[0], ((Number)result[1]).intValue());
        }
        return Collections.unmodifiableMap(countByRealm);
    }

    public Map<String, Integer> countByRealm(AnyType anyType) {
        Query query = this.entityManager().createQuery("SELECT e.realm, COUNT(e) FROM  " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.type=:type GROUP BY e.realm");
        query.setParameter("type", (Object)anyType);
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).intValue()));
    }

    @Override
    protected void securityChecks(AnyObject anyObject) {
        Map authorizations = AuthContextUtils.getAuthorizations();
        Set authRealms = authorizations.containsKey(AnyEntitlement.READ.getFor(anyObject.getType().getKey())) ? (Set)authorizations.get(AnyEntitlement.READ.getFor(anyObject.getType().getKey())) : Collections.emptySet();
        boolean authorized = authRealms.stream().anyMatch(realm -> anyObject.getRealm().getFullPath().startsWith((String)realm));
        if (!authorized) {
            boolean bl = authorized = this.findDynRealms(anyObject.getKey()).stream().filter(dynRealm -> authRealms.contains(dynRealm)).count() > 0L;
        }
        if (authRealms.isEmpty() || !authorized) {
            throw new DelegatedAdministrationException(anyObject.getRealm().getFullPath(), AnyTypeKind.ANY_OBJECT.name(), anyObject.getKey());
        }
    }

    public AnyObject findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.name = :name", AnyObject.class);
        query.setParameter("name", (Object)name);
        AnyObject result = null;
        try {
            result = (AnyObject)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No any object found with name {}", (Object)name, (Object)e);
        }
        return result;
    }

    public AMembership findMembership(String key) {
        return (AMembership)this.entityManager().find(JPAAMembership.class, (Object)key);
    }

    public List<Relationship<Any<?>, AnyObject>> findAllRelationships(AnyObject anyObject) {
        ArrayList result = new ArrayList();
        TypedQuery aquery = (TypedQuery)this.entityManager().createQuery("SELECT e FROM " + JPAARelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject OR e.leftEnd=:anyObject");
        aquery.setParameter("anyObject", (Object)anyObject);
        result.addAll(aquery.getResultList());
        TypedQuery uquery = (TypedQuery)this.entityManager().createQuery("SELECT e FROM " + JPAURelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject");
        uquery.setParameter("anyObject", (Object)anyObject);
        result.addAll(uquery.getResultList());
        return result;
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + this.anyUtils().anyClass().getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public List<AnyObject> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + this.anyUtils().anyClass().getSimpleName() + " e ORDER BY e.id", AnyObject.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    public List<String> findAllKeys(int page, int itemsPerPage) {
        return this.findAllKeys("AnyObject", page, itemsPerPage);
    }

    protected Pair<AnyObject, Pair<Set<String>, Set<String>>> doSave(AnyObject anyObject) {
        AnyObject merged = super.save(anyObject);
        this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)merged, AuthContextUtils.getDomain()));
        Pair dynGroupMembs = this.groupDAO.refreshDynMemberships(merged);
        this.dynRealmDAO.refreshDynMemberships((Any)merged);
        return Pair.of((Object)merged, (Object)dynGroupMembs);
    }

    @Override
    public AnyObject save(AnyObject anyObject) {
        return (AnyObject)this.doSave(anyObject).getLeft();
    }

    public Pair<Set<String>, Set<String>> saveAndGetDynGroupMembs(AnyObject anyObject) {
        return (Pair)this.doSave(anyObject).getRight();
    }

    protected List<ARelationship> findARelationships(AnyObject anyObject) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAARelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject", ARelationship.class);
        query.setParameter("anyObject", (Object)anyObject);
        return query.getResultList();
    }

    protected List<URelationship> findURelationships(AnyObject anyObject) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAURelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject", URelationship.class);
        query.setParameter("anyObject", (Object)anyObject);
        return query.getResultList();
    }

    public void delete(AnyObject anyObject) {
        this.groupDAO.removeDynMemberships(anyObject);
        this.dynRealmDAO.removeDynMemberships(anyObject.getKey());
        this.findARelationships(anyObject).forEach(relationship -> {
            ((AnyObject)relationship.getLeftEnd()).getRelationships().remove(relationship);
            this.save((AnyObject)relationship.getLeftEnd());
            this.entityManager().remove(relationship);
        });
        this.findURelationships(anyObject).forEach(relationship -> {
            ((User)relationship.getLeftEnd()).getRelationships().remove(relationship);
            this.userDAO.save(relationship.getLeftEnd());
            this.entityManager().remove(relationship);
        });
        this.entityManager().remove((Object)anyObject);
        this.publisher.publishEvent((ApplicationEvent)new AnyDeletedEvent((Object)this, AnyTypeKind.ANY_OBJECT, anyObject.getKey(), anyObject.getName(), AuthContextUtils.getDomain()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Group> findDynGroups(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT group_id FROM ADynGroupMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<Group> result = new ArrayList<Group>();
        query.getResultList().stream().map(resultKey -> resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey).forEach(groupKey -> {
            Group group = (Group)this.groupDAO.find(groupKey.toString());
            if (group == null) {
                LOG.error("Could not find group {}, even though returned by the native query", groupKey);
            } else if (!result.contains(group)) {
                result.add(group);
            }
        });
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(AnyObject anyObject) {
        HashSet<Group> result = new HashSet<Group>();
        result.addAll(anyObject.getMemberships().stream().map(membership -> (Group)membership.getRightEnd()).collect(Collectors.toSet()));
        result.addAll(this.findDynGroups(anyObject.getKey()));
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(AnyObject anyObject) {
        return this.findAllGroups(anyObject).stream().map(group -> group.getKey()).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(AnyObject anyObject) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(anyObject.getResources());
        this.findAllGroups(anyObject).forEach(group -> result.addAll(group.getResources()));
        return result;
    }

    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findAllResources((AnyObject)this.authFind(key)).stream().map(resource -> resource.getKey()).collect(Collectors.toList());
    }
}

