/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAccessToken;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPAAccessTokenDAO
extends AbstractDAO<AccessToken>
implements AccessTokenDAO {
    @Transactional(readOnly=true)
    public AccessToken find(String key) {
        return (AccessToken)this.entityManager().find(JPAAccessToken.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public AccessToken findByOwner(String username) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAccessToken.class.getSimpleName() + " e WHERE e.owner=:username", AccessToken.class);
        query.setParameter("username", (Object)username);
        AccessToken result = null;
        try {
            result = (AccessToken)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No token for user {} could be found", (Object)username, (Object)e);
        }
        return result;
    }

    private StringBuilder buildFindAllQuery() {
        return new StringBuilder("SELECT e FROM ").append(JPAAccessToken.class.getSimpleName()).append(" e WHERE 1=1");
    }

    @Transactional(readOnly=true)
    public int count() {
        StringBuilder queryString = this.buildFindAllQuery();
        Query query = this.entityManager().createQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)"SELECT e", (String)"SELECT COUNT(e)"));
        return ((Number)query.getSingleResult()).intValue();
    }

    private String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(JPAAccessToken.class, (String)field) == null) continue;
            statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
        }
        if (statement.length() == 0) {
            statement.append("ORDER BY e.expiryTime DESC");
        } else {
            statement.insert(0, "ORDER BY ");
        }
        return statement.toString();
    }

    @Transactional(readOnly=true)
    public List<AccessToken> findAll(int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.buildFindAllQuery().append(this.toOrderByStatement(orderByClauses));
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), AccessToken.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public AccessToken save(AccessToken accessToken) {
        return (AccessToken)this.entityManager().merge((Object)accessToken);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void delete(String key) {
        AccessToken accessToken = this.find(key);
        if (accessToken == null) {
            return;
        }
        this.delete(accessToken);
    }

    public void delete(AccessToken accessToken) {
        this.entityManager().remove((Object)accessToken);
    }

    public int deleteExpired() {
        Query query = this.entityManager().createQuery("DELETE FROM " + JPAAccessToken.class.getSimpleName() + " e WHERE e.expiryTime < :now");
        query.setParameter("now", (Object)new Date());
        return query.executeUpdate();
    }
}

