/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.scim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.scim.SCIMComplexConf;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMUserAddressConf;
import org.apache.syncope.common.lib.scim.SCIMUserConf;
import org.apache.syncope.core.logic.scim.SCIMFilterBaseVisitor;
import org.apache.syncope.core.logic.scim.SCIMFilterParser;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.ext.scimv2.api.type.Resource;

public class SearchCondVisitor
extends SCIMFilterBaseVisitor<SearchCond> {
    private static final List<String> MULTIVALUE = Arrays.asList("emails", "phoneNumbers", "ims", "photos", "addresses");
    private final Resource resource;
    private final SCIMConf conf;

    public SearchCondVisitor(Resource resource, SCIMConf conf) {
        this.resource = resource;
        this.conf = conf;
    }

    @Override
    public SearchCond visitScimFilter(SCIMFilterParser.ScimFilterContext ctx) {
        return (SearchCond)this.visit((ParseTree)ctx.expression(0));
    }

    private boolean schemaEquals(Resource resource, String value, String schema) {
        return resource == null ? (value.contains(":") ? StringUtils.substringAfterLast((String)value, (String)":").equalsIgnoreCase(schema) : value.equalsIgnoreCase(schema)) : value.equalsIgnoreCase(schema) || (resource.schema() + ":" + value).equalsIgnoreCase(schema);
    }

    public AttrCond createAttrCond(String schema) {
        AnyCond attrCond = null;
        if (this.schemaEquals(Resource.User, "userName", schema)) {
            attrCond = new AnyCond();
            attrCond.setSchema("username");
        } else if (this.resource == Resource.Group && this.schemaEquals(Resource.Group, "displayName", schema)) {
            attrCond = new AnyCond();
            attrCond.setSchema("name");
        } else if (this.schemaEquals(null, "meta.created", schema)) {
            attrCond = new AnyCond();
            attrCond.setSchema("creationDate");
        } else if (this.schemaEquals(null, "meta.lastModified", schema)) {
            attrCond = new AnyCond();
            attrCond.setSchema("lastChangeDate");
        }
        if (this.resource == Resource.User) {
            if (this.conf.getUserConf() != null) {
                if (this.conf.getUserConf().getName() != null) {
                    for (Map.Entry entry : this.conf.getUserConf().getName().asMap().entrySet()) {
                        if (!this.schemaEquals(Resource.User, "name." + (String)entry.getKey(), schema)) continue;
                        attrCond = new AttrCond();
                        attrCond.setSchema((String)entry.getValue());
                    }
                }
                for (Map.Entry entry : this.conf.getUserConf().asMap().entrySet()) {
                    if (!this.schemaEquals(Resource.User, (String)entry.getKey(), schema)) continue;
                    attrCond = new AttrCond();
                    attrCond.setSchema((String)entry.getValue());
                }
                for (SCIMUserAddressConf address : this.conf.getUserConf().getAddresses()) {
                    for (Map.Entry entry : address.asMap().entrySet()) {
                        if (!this.schemaEquals(Resource.User, "addresses." + (String)entry.getKey(), schema)) continue;
                        attrCond = new AttrCond();
                        attrCond.setSchema((String)entry.getValue());
                    }
                }
            }
            if (this.conf.getEnterpriseUserConf() != null) {
                for (Map.Entry entry : this.conf.getEnterpriseUserConf().asMap().entrySet()) {
                    if (!this.schemaEquals(Resource.EnterpriseUser, (String)entry.getKey(), schema)) continue;
                    attrCond = new AttrCond();
                    attrCond.setSchema((String)entry.getValue());
                }
                if (this.conf.getEnterpriseUserConf().getManager() != null && this.conf.getEnterpriseUserConf().getManager().getKey() != null) {
                    attrCond = new AttrCond();
                    attrCond.setSchema(this.conf.getEnterpriseUserConf().getManager().getKey());
                }
            }
        }
        if (attrCond == null) {
            throw new IllegalArgumentException("Could not match " + schema + " for " + this.resource);
        }
        return attrCond;
    }

    private SearchCond setOperator(AttrCond attrCond, String operator) {
        switch (operator) {
            default: {
                attrCond.setType(AttrCond.Type.IEQ);
                break;
            }
            case "ne": {
                attrCond.setType(AttrCond.Type.IEQ);
                break;
            }
            case "sw": {
                attrCond.setType(AttrCond.Type.ILIKE);
                attrCond.setExpression(attrCond.getExpression() + "%");
                break;
            }
            case "co": {
                attrCond.setType(AttrCond.Type.ILIKE);
                attrCond.setExpression("%" + attrCond.getExpression() + "%");
                break;
            }
            case "ew": {
                attrCond.setType(AttrCond.Type.ILIKE);
                attrCond.setExpression("%" + attrCond.getExpression());
                break;
            }
            case "gt": {
                attrCond.setType(AttrCond.Type.GT);
                break;
            }
            case "ge": {
                attrCond.setType(AttrCond.Type.GE);
                break;
            }
            case "lt": {
                attrCond.setType(AttrCond.Type.LT);
                break;
            }
            case "le": {
                attrCond.setType(AttrCond.Type.LE);
            }
        }
        return "ne".equals(operator) ? SearchCond.getNotLeaf((AbstractSearchCond)attrCond) : SearchCond.getLeaf((AbstractSearchCond)attrCond);
    }

    private <E extends Enum<?>> SearchCond complex(String operator, String left, String right, List<SCIMComplexConf<E>> items) {
        if (left.endsWith(".type")) {
            Optional<SCIMComplexConf> item2 = items.stream().filter(object -> object.getType().name().equals(StringUtils.strip((String)right, (String)"\""))).findFirst();
            if (item2.isPresent()) {
                AttrCond attrCond = new AttrCond();
                attrCond.setSchema(item2.get().getValue());
                attrCond.setType(AttrCond.Type.ISNOTNULL);
                return SearchCond.getLeaf((AbstractSearchCond)attrCond);
            }
        } else if (!this.conf.getUserConf().getEmails().isEmpty() && (MULTIVALUE.contains(left) || left.endsWith(".value"))) {
            ArrayList orConds = new ArrayList();
            items.forEach(item -> {
                AttrCond cond = new AttrCond();
                cond.setSchema(item.getValue());
                cond.setExpression(StringUtils.strip((String)right, (String)"\""));
                orConds.add(this.setOperator(cond, operator));
            });
            if (!orConds.isEmpty()) {
                return SearchCond.getOr(orConds);
            }
        }
        return null;
    }

    private SearchCond addresses(String operator, String left, String right, List<SCIMUserAddressConf> items) {
        if (left.endsWith(".type") && "eq".equals(operator)) {
            Optional<SCIMUserAddressConf> item2 = items.stream().filter(object -> object.getType().name().equals(StringUtils.strip((String)right, (String)"\""))).findFirst();
            if (item2.isPresent()) {
                AttrCond attrCond = new AttrCond();
                attrCond.setSchema(item2.get().getFormatted());
                attrCond.setType(AttrCond.Type.ISNOTNULL);
                return SearchCond.getLeaf((AbstractSearchCond)attrCond);
            }
        } else if (!this.conf.getUserConf().getEmails().isEmpty() && (MULTIVALUE.contains(left) || left.endsWith(".value"))) {
            ArrayList orConds = new ArrayList();
            items.forEach(item -> {
                AttrCond cond = new AttrCond();
                cond.setSchema(item.getFormatted());
                cond.setExpression(StringUtils.strip((String)right, (String)"\""));
                orConds.add(this.setOperator(cond, operator));
            });
            if (!orConds.isEmpty()) {
                return SearchCond.getOr(orConds);
            }
        }
        return null;
    }

    private SearchCond transform(String operator, String left, String right) {
        SearchCond result = null;
        if (MULTIVALUE.contains(StringUtils.substringBefore((String)left, (String)"."))) {
            if (this.conf.getUserConf() == null) {
                throw new IllegalArgumentException("No " + SCIMUserConf.class.getName() + " provided, cannot continue");
            }
            switch (StringUtils.substringBefore((String)left, (String)".")) {
                case "emails": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getEmails());
                    break;
                }
                case "phoneNumbers": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getPhoneNumbers());
                    break;
                }
                case "ims": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getIms());
                    break;
                }
                case "photos": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getPhotos());
                    break;
                }
                case "addresses": {
                    result = this.addresses(operator, left, right, this.conf.getUserConf().getAddresses());
                    break;
                }
            }
        }
        if (result == null) {
            AttrCond attrCond = this.createAttrCond(left);
            attrCond.setExpression(StringUtils.strip((String)right, (String)"\""));
            result = this.setOperator(attrCond, operator);
        }
        if (result == null) {
            throw new IllegalArgumentException("Could not handle (" + left + " " + operator + " " + right + ") for " + this.resource);
        }
        return result;
    }

    @Override
    public SearchCond visitEXPR_OPER_EXPR(SCIMFilterParser.EXPR_OPER_EXPRContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.expression(0).getText(), ctx.expression(1).getText());
    }

    @Override
    public SearchCond visitATTR_OPER_CRITERIA(SCIMFilterParser.ATTR_OPER_CRITERIAContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.ATTRNAME().getText(), ctx.criteria().getText());
    }

    @Override
    public SearchCond visitATTR_OPER_EXPR(SCIMFilterParser.ATTR_OPER_EXPRContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.ATTRNAME().getText(), ctx.expression().getText());
    }

    @Override
    public SearchCond visitATTR_PR(SCIMFilterParser.ATTR_PRContext ctx) {
        AttrCond cond = this.createAttrCond(ctx.ATTRNAME().getText());
        cond.setType(AttrCond.Type.ISNOTNULL);
        return SearchCond.getLeaf((AbstractSearchCond)cond);
    }

    @Override
    public SearchCond visitLPAREN_EXPR_RPAREN(SCIMFilterParser.LPAREN_EXPR_RPARENContext ctx) {
        return (SearchCond)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public SearchCond visitNOT_EXPR(SCIMFilterParser.NOT_EXPRContext ctx) {
        SearchCond cond = (SearchCond)this.visit((ParseTree)ctx.expression());
        Optional anyCond = cond.getLeaf(AnyCond.class);
        if (anyCond.isPresent()) {
            if (((AnyCond)anyCond.get()).getType() == AttrCond.Type.ISNULL) {
                ((AnyCond)anyCond.get()).setType(AttrCond.Type.ISNOTNULL);
            } else if (((AnyCond)anyCond.get()).getType() == AttrCond.Type.ISNOTNULL) {
                ((AnyCond)anyCond.get()).setType(AttrCond.Type.ISNULL);
            }
        } else {
            Optional attrCond = cond.getLeaf(AttrCond.class);
            if (attrCond.isPresent()) {
                if (((AttrCond)attrCond.get()).getType() == AttrCond.Type.ISNULL) {
                    ((AttrCond)attrCond.get()).setType(AttrCond.Type.ISNOTNULL);
                } else if (((AttrCond)attrCond.get()).getType() == AttrCond.Type.ISNOTNULL) {
                    ((AttrCond)attrCond.get()).setType(AttrCond.Type.ISNULL);
                }
            } else {
                cond = SearchCond.getNotLeaf((AbstractSearchCond)cond);
            }
        }
        return cond;
    }

    @Override
    public SearchCond visitEXPR_AND_EXPR(SCIMFilterParser.EXPR_AND_EXPRContext ctx) {
        return SearchCond.getAnd((SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(0))), (SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(1))));
    }

    @Override
    public SearchCond visitEXPR_OR_EXPR(SCIMFilterParser.EXPR_OR_EXPRContext ctx) {
        return SearchCond.getOr((SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(0))), (SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(1))));
    }
}

