/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;

class AttributeDeserializer
extends JsonDeserializer<Attribute> {
    AttributeDeserializer() {
    }

    public Attribute deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        String name = tree.get("name").asText();
        ArrayList<Object> values = new ArrayList<Object>();
        for (JsonNode node : tree.get("value")) {
            if (node.isNull()) {
                values.add(null);
                continue;
            }
            if (node.isObject()) {
                values.add(((ObjectNode)node).traverse(jp.getCodec()).readValueAs(GuardedString.class));
                continue;
            }
            if (node.isBoolean()) {
                values.add(node.asBoolean());
                continue;
            }
            if (node.isDouble()) {
                values.add(node.asDouble());
                continue;
            }
            if (node.isLong()) {
                values.add(node.asLong());
                continue;
            }
            if (node.isInt()) {
                values.add(node.asInt());
                continue;
            }
            String text = node.asText();
            if (text.startsWith("<binary>") && text.endsWith("</binary>")) {
                values.add(Base64.getDecoder().decode(StringUtils.substringBetween((String)text, (String)"<binary>", (String)"</binary>")));
                continue;
            }
            values.add(text);
        }
        if (Uid.NAME.equals(name)) {
            return new Uid(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
        }
        if (Name.NAME.equals(name)) {
            return new Name(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
        }
        return AttributeBuilder.build((String)name, values);
    }
}

