/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ModuleInfo;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.Resource;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.types.Parser;
import nonapi.io.github.classgraph.utils.Join;
import nonapi.io.github.classgraph.utils.LogNode;

class ClassInfoUnlinked {
    final String className;
    private final int classModifiers;
    private final boolean isInterface;
    private final boolean isAnnotation;
    private final boolean isExternalClass;
    String superclassName;
    List<String> implementedInterfaces;
    AnnotationInfoList classAnnotations;
    private String fullyQualifiedDefiningMethodName;
    private List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries;
    private AnnotationParameterValueList annotationParamDefaultValues;
    private final Set<String> refdClassNames;
    final ClasspathElement classpathElement;
    final Resource classfileResource;
    FieldInfoList fieldInfoList;
    MethodInfoList methodInfoList;
    private String typeSignature;

    ClassInfoUnlinked(String className, String superclassName, int classModifiers, boolean isInterface, boolean isAnnotation, boolean isExternalClass, Set<String> refdClassNames, ClasspathElement classpathElement, Resource classfileResource) {
        this.className = className;
        this.superclassName = superclassName;
        this.classModifiers = classModifiers;
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
        this.isExternalClass = isExternalClass;
        this.refdClassNames = refdClassNames;
        this.classpathElement = classpathElement;
        this.classfileResource = classfileResource;
    }

    void addTypeSignature(String typeSignature) {
        this.typeSignature = typeSignature;
    }

    void addImplementedInterface(String interfaceName) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList<String>();
        }
        this.implementedInterfaces.add(interfaceName);
    }

    void addClassAnnotation(AnnotationInfo classAnnotation) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new AnnotationInfoList();
        }
        this.classAnnotations.add(classAnnotation);
    }

    void addFieldInfo(FieldInfo fieldInfo) {
        if (this.fieldInfoList == null) {
            this.fieldInfoList = new FieldInfoList();
        }
        this.fieldInfoList.add(fieldInfo);
    }

    void addMethodInfo(MethodInfo methodInfo) {
        if (this.methodInfoList == null) {
            this.methodInfoList = new MethodInfoList();
        }
        this.methodInfoList.add(methodInfo);
    }

    public void addEnclosingMethod(String fullyQualifiedDefiningMethodName) {
        this.fullyQualifiedDefiningMethodName = fullyQualifiedDefiningMethodName;
    }

    public void addClassContainment(String innerClassName, String outerClassName) {
        if (this.classContainmentEntries == null) {
            this.classContainmentEntries = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        }
        this.classContainmentEntries.add(new AbstractMap.SimpleEntry<String, String>(innerClassName, outerClassName));
    }

    public void addAnnotationParamDefaultValue(AnnotationParameterValue annotationParamDefaultValue) {
        if (this.annotationParamDefaultValues == null) {
            this.annotationParamDefaultValues = new AnnotationParameterValueList();
        }
        this.annotationParamDefaultValues.add(annotationParamDefaultValue);
    }

    void link(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo, Map<String, PackageInfo> packageNameToPackageInfo, Map<String, ModuleInfo> moduleNameToModuleInfo, LogNode log) {
        if (this.className.equals("module-info")) {
            ModuleInfo moduleInfo = moduleNameToModuleInfo.get(this.classpathElement.moduleName);
            if (moduleInfo == null) {
                moduleInfo = new ModuleInfo(this.classfileResource.getModuleRef(), this.classpathElement);
                moduleNameToModuleInfo.put(this.classpathElement.moduleName, moduleInfo);
            }
            moduleInfo.addAnnotations(this.classAnnotations);
        } else if (this.className.equals("package-info") || this.className.endsWith(".package-info")) {
            int lastDotIdx = this.className.lastIndexOf(46);
            String packageName = lastDotIdx < 0 ? "" : this.className.substring(0, lastDotIdx);
            PackageInfo packageInfo = PackageInfo.getPackage(packageName, packageNameToPackageInfo);
            packageInfo.addAnnotations(this.classAnnotations);
        } else {
            int lastDotIdx;
            ClassInfo classInfo = ClassInfo.addScannedClass(this.className, this.classModifiers, this.isInterface, this.isAnnotation, this.isExternalClass, classNameToClassInfo, this.classpathElement, this.classfileResource, scanSpec, log);
            if (this.superclassName != null) {
                classInfo.addSuperclass(this.superclassName, classNameToClassInfo);
            }
            if (this.implementedInterfaces != null) {
                for (String interfaceName : this.implementedInterfaces) {
                    classInfo.addImplementedInterface(interfaceName, classNameToClassInfo);
                }
            }
            if (this.classAnnotations != null) {
                for (AnnotationInfo classAnnotation : this.classAnnotations) {
                    classInfo.addClassAnnotation(classAnnotation, classNameToClassInfo);
                }
            }
            if (this.classContainmentEntries != null) {
                ClassInfo.addClassContainment(this.classContainmentEntries, classNameToClassInfo);
            }
            if (this.annotationParamDefaultValues != null) {
                classInfo.addAnnotationParamDefaultValues(this.annotationParamDefaultValues);
            }
            if (this.fullyQualifiedDefiningMethodName != null) {
                classInfo.addFullyQualifiedDefiningMethodName(this.fullyQualifiedDefiningMethodName);
            }
            if (this.fieldInfoList != null) {
                classInfo.addFieldInfo(this.fieldInfoList, classNameToClassInfo);
            }
            if (this.methodInfoList != null) {
                classInfo.addMethodInfo(this.methodInfoList, classNameToClassInfo);
            }
            if (this.typeSignature != null) {
                classInfo.addTypeSignature(this.typeSignature);
            }
            if (this.refdClassNames != null) {
                classInfo.addReferencedClassNames(this.refdClassNames);
            }
            String packageName = (lastDotIdx = this.className.lastIndexOf(46)) < 0 ? "" : this.className.substring(0, lastDotIdx);
            PackageInfo packageInfo = PackageInfo.getPackage(packageName, packageNameToPackageInfo);
            packageInfo.addClassInfo(classInfo);
            ModuleInfo moduleInfo = moduleNameToModuleInfo.get(this.classpathElement.moduleName);
            if (moduleInfo == null) {
                moduleInfo = new ModuleInfo(classInfo.getModuleRef(), this.classpathElement);
                moduleNameToModuleInfo.put(this.classpathElement.moduleName, moduleInfo);
            }
            moduleInfo.addClassInfo(classInfo);
            moduleInfo.addPackageInfo(packageInfo);
        }
    }

    void logTo(LogNode log) {
        if (log != null) {
            LogNode subLog = log.log("Found " + (this.isAnnotation ? "annotation class" : (this.isInterface ? "interface class" : "class")) + " " + this.className);
            if (this.superclassName != null) {
                subLog.log("Super" + (this.isInterface && !this.isAnnotation ? "interface" : "class") + ": " + this.superclassName);
            }
            if (this.implementedInterfaces != null) {
                subLog.log("Interfaces: " + Join.join(", ", this.implementedInterfaces));
            }
            if (this.classAnnotations != null) {
                subLog.log("Class annotations: " + Join.join(", ", this.classAnnotations));
            }
            if (this.annotationParamDefaultValues != null) {
                for (AnnotationParameterValue apv : this.annotationParamDefaultValues) {
                    subLog.log("Annotation default param value: " + apv);
                }
            }
            if (this.fieldInfoList != null) {
                for (FieldInfo fieldInfo : this.fieldInfoList) {
                    subLog.log("Field: " + fieldInfo);
                }
            }
            if (this.methodInfoList != null) {
                for (MethodInfo methodInfo : this.methodInfoList) {
                    subLog.log("Method: " + methodInfo);
                }
            }
            if (this.typeSignature != null) {
                ClassTypeSignature typeSig = null;
                try {
                    typeSig = ClassTypeSignature.parse(this.typeSignature, null);
                }
                catch (Parser.ParseException parseException) {
                    // empty catch block
                }
                subLog.log("Class type signature: " + (typeSig == null ? this.typeSignature : typeSig.toString(this.className, false, this.classModifiers, this.isAnnotation, this.isInterface)));
            }
        }
    }
}

