/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.licensing.Licensing;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class GoogleAppsConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private String domain = null;
    private String clientId;
    private GuardedString clientSecret = null;
    private GuardedString refreshToken = null;
    private Credential credential = null;
    private Directory directory;
    private Licensing licensing;

    @ConfigurationProperty(order=1, displayMessageKey="domain.display", groupMessageKey="basic.group", helpMessageKey="domain.help", required=true, confidential=false)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=2, displayMessageKey="clientid.display", groupMessageKey="basic.group", helpMessageKey="clientid.help", required=true, confidential=false)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(order=3, displayMessageKey="clientsecret.display", groupMessageKey="basic.group", helpMessageKey="clientsecret.help", required=true, confidential=true)
    public GuardedString getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GuardedString clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ConfigurationProperty(order=4, displayMessageKey="refreshtoken.display", groupMessageKey="basic.group", helpMessageKey="refreshtoken.help", required=true, confidential=true)
    public GuardedString getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(GuardedString refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.domain)) {
            throw new IllegalArgumentException("Domain cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.clientId)) {
            throw new IllegalArgumentException("Client Id cannot be null or empty.");
        }
        if (null == this.clientSecret) {
            throw new IllegalArgumentException("Client Secret cannot be null.");
        }
        if (null == this.refreshToken) {
            throw new IllegalArgumentException("Refresh Token cannot be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential getGoogleCredential() {
        GoogleAppsConfiguration googleAppsConfiguration = this;
        synchronized (googleAppsConfiguration) {
            if (null == this.credential) {
                this.credential = new GoogleCredential.Builder().setTransport(HTTP_TRANSPORT).setJsonFactory(JSON_FACTORY).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.getClientId(), SecurityUtil.decrypt((GuardedString)this.getClientSecret()))).build();
                this.getRefreshToken().access(new GuardedString.Accessor(){

                    public void access(char[] chars) {
                        GoogleAppsConfiguration.this.credential.setRefreshToken(new String(chars));
                    }
                });
                this.directory = new Directory.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)this.credential).setApplicationName("ConnId").build();
                this.licensing = new Licensing.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)this.credential).setApplicationName("ConnId").build();
            }
        }
        return this.credential;
    }

    public void release() {
    }

    public Directory getDirectory() {
        this.getGoogleCredential();
        return this.directory;
    }

    public Licensing getLicensing() {
        this.getGoogleCredential();
        if (null == this.licensing) {
            throw new ConnectorException("Licensing is not enabled");
        }
        return this.licensing;
    }
}

