/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.oidcclient.agent;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="oidcclientlogout", urlPatterns={"/oidcclient/logout"})
public class Logout
extends HttpServlet {
    private static final long serialVersionUID = 2383239908659843071L;
    protected static final Logger LOG = LoggerFactory.getLogger(Logout.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String successURL = this.getServletContext().getInitParameter("oidcclient.logout.success.url");
            if (successURL == null) {
                request.getRequestDispatcher("logoutSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(successURL);
            }
            request.getSession().removeAttribute("oidcclient.jwt");
        }
        catch (Exception e) {
            LOG.error("While processing authentication response from IdP", (Throwable)e);
            String errorURL = this.getServletContext().getInitParameter("oidcclient.logout.error.url");
            if (errorURL == null) {
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher("logoutError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                e.printStackTrace(response.getWriter());
            }
            response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
        }
    }
}

