/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import liquibase.exception.UnexpectedLiquibaseException;

public class LiquibaseUtil {
    public static String getBuildVersion() {
        return LiquibaseUtil.getBuildInfo("build.version", "Bundle-Version");
    }

    public static String getBuildTime() {
        return LiquibaseUtil.getBuildInfo("build.timestamp", "Build-Time");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBuildInfo(String propertyId, String manifestId) {
        String buildInfoValue;
        block18: {
            buildInfoValue = "UNKNOWN";
            Class<LiquibaseUtil> clazz = LiquibaseUtil.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (classPath.startsWith("jar")) {
                String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
                Manifest manifest = null;
                try {
                    manifest = new Manifest(new URL(manifestPath).openStream());
                }
                catch (IOException e) {
                    throw new UnexpectedLiquibaseException("Cannot open a URL to the manifest of our own JAR file.");
                }
                Attributes attr = manifest.getMainAttributes();
                buildInfoValue = attr.getValue(manifestId);
            }
            if (buildInfoValue.equals("UNKNOWN")) {
                Properties buildInfo = new Properties();
                ClassLoader classLoader = LiquibaseUtil.class.getClassLoader();
                URL buildInfoFile = classLoader.getResource("buildinfo.properties");
                InputStream in = null;
                try {
                    if (buildInfoFile != null) {
                        URLConnection connection = buildInfoFile.openConnection();
                        connection.setUseCaches(false);
                        in = connection.getInputStream();
                        buildInfo.load(in);
                        String o = (String)buildInfo.get(propertyId);
                        if (o != null) {
                            buildInfoValue = o;
                        }
                    }
                }
                catch (IOException e) {
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException("Failed to close InputStream in LiquibaseUtil.", e2);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to close InputStream in LiquibaseUtil.", e);
                        }
                    }
                }
            }
        }
        return buildInfoValue;
    }
}

