/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import liquibase.ScopeManager;
import liquibase.SingletonObject;
import liquibase.SingletonScopeFactory;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.listener.LiquibaseListener;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.SmartMap;

public class Scope {
    private static ScopeManager scopeManager = new SingletonScopeFactory();
    private Scope parent;
    private SmartMap values = new SmartMap();
    private LiquibaseListener listener;

    public static Scope getCurrentScope() {
        return scopeManager.getCurrentScope();
    }

    Scope() {
        this.values.put(Attr.resourceAccessor.name(), (Object)new ClassLoaderResourceAccessor());
    }

    protected Scope(Scope parent, Map<String, Object> scopeValues) {
        this.parent = parent;
        if (scopeValues != null) {
            for (Map.Entry<String, Object> entry : scopeValues.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Scope getParent() {
        return this.parent;
    }

    public static void child(Map<String, Object> scopeValues, ScopedRunner runner) {
        Scope.child(null, scopeValues, runner);
    }

    public static void child(LiquibaseListener listener, ScopedRunner runner) {
        Scope.child(listener, null, runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void child(LiquibaseListener listener, Map<String, Object> scopeValues, ScopedRunner runner) {
        Scope originalScope = Scope.getCurrentScope();
        Scope child = new Scope(originalScope, scopeValues);
        child.listener = listener;
        try {
            scopeManager.setCurrentScope(child);
            runner.run();
        }
        finally {
            scopeManager.setCurrentScope(originalScope);
        }
    }

    public void child(String newValueKey, Object newValue, ScopedRunner runner) {
        HashMap<String, Object> scopeValues = new HashMap<String, Object>();
        scopeValues.put(newValueKey, newValue);
        Scope.child(scopeValues, runner);
    }

    public void child(Enum newValueKey, Object newValue, ScopedRunner runner) {
        this.child(newValueKey.name(), newValue, runner);
    }

    public boolean has(String key) {
        return this.get(key, (Object)Object.class) != null;
    }

    public boolean has(Enum key) {
        return this.has(key.name());
    }

    public <T> T get(Enum key, Class<T> type) {
        return (T)this.get(key.name(), (T)type);
    }

    public <T> T get(Enum key, T defaultValue) {
        return this.get(key.name(), defaultValue);
    }

    public <T> T get(String key, Class<T> type) {
        Class<T> value = this.values.get(key, type);
        if (value == null && this.parent != null) {
            value = this.parent.get(key, (T)type);
        }
        return (T)value;
    }

    public <T> T get(String key, T defaultValue) {
        Class type = defaultValue == null ? Object.class : defaultValue.getClass();
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T extends SingletonObject> T getSingleton(Class<T> type) {
        if (this.getParent() != null) {
            return this.getParent().getSingleton(type);
        }
        String key = type.getName();
        SingletonObject singleton = (SingletonObject)((Object)this.get(key, (T)type));
        if (singleton == null) {
            try {
                try {
                    Constructor<T> constructor = type.getDeclaredConstructor(Scope.class);
                    constructor.setAccessible(true);
                    singleton = (SingletonObject)constructor.newInstance(this);
                }
                catch (NoSuchMethodException e) {
                    Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    singleton = (SingletonObject)constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
            this.values.put(key, (Object)singleton);
        }
        return (T)singleton;
    }

    public Database getDatabase() {
        return (Database)((Object)this.get((Enum)Attr.database, (Object)Database.class));
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)((Object)this.get((Enum)Attr.classLoader, (Object)ClassLoader.class));
    }

    public ClassLoader getClassLoader(boolean fallbackToContextClassLoader) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null && fallbackToContextClassLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public ResourceAccessor getResourceAccessor() {
        return (ResourceAccessor)((Object)this.get((Enum)Attr.resourceAccessor, (Object)ResourceAccessor.class));
    }

    public String getLineSeparator() {
        return this.get((Enum)Attr.lineSeparator, System.lineSeparator());
    }

    public <T extends LiquibaseListener> Collection<T> getListeners(Class<T> type) {
        ArrayList<LiquibaseListener> returnList = new ArrayList<LiquibaseListener>();
        for (Scope scopeToCheck = this; scopeToCheck != null; scopeToCheck = scopeToCheck.getParent()) {
            if (scopeToCheck.listener == null || !type.isAssignableFrom(scopeToCheck.listener.getClass())) continue;
            returnList.add(scopeToCheck.listener);
        }
        return returnList;
    }

    public String toString() {
        return this.describe();
    }

    public String describe() {
        String databaseName = null;
        Database database = this.getDatabase();
        if (database != null) {
            databaseName = database.getShortName();
            DatabaseConnection connection = database.getConnection();
            if (connection == null) {
                databaseName = "unconnected " + databaseName;
            } else if (connection instanceof OfflineConnection) {
                databaseName = "offline " + databaseName;
            } else if (connection instanceof JdbcConnection) {
                databaseName = "jdbc " + databaseName;
            }
        }
        return "scope(database=" + databaseName + ")";
    }

    public Logger getLog(Class clazz) {
        return LogService.getLog(clazz);
    }

    public static interface ScopedRunner {
        public void run();
    }

    public static enum Attr {
        resourceAccessor,
        classLoader,
        database,
        quotingStrategy,
        changeLogHistoryService,
        lockService,
        executeMode,
        lineSeparator;

    }
}

