/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.processor;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.panels.userinput.processor.Processor;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.util.Base64;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class PasswordEncryptionProcessor
implements Processor {
    private Cipher encryptCipher;
    private static final Logger logger = Logger.getLogger(PasswordEncryptionProcessor.class.getName());

    @Override
    public String process(ProcessingClient client) {
        String key = client.getConfigurationOptionValue("encryptionKey", null);
        String algorithm = client.getConfigurationOptionValue("algorithm", null);
        if (key == null || algorithm == null) {
            throw new IzPackException("PasswordEncryptionProcessor requires encryptionKey and algorithm parameters");
        }
        this.initialize(key, algorithm);
        String result = this.encryptString(client.getFieldContents(0));
        return result;
    }

    private void initialize(String key, String algorithm) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            keygen.init(new SecureRandom(key.getBytes()));
            byte[] keyBytes = keygen.generateKey().getEncoded();
            SecretKeySpec specKey = new SecretKeySpec(keyBytes, algorithm);
            this.encryptCipher = Cipher.getInstance(algorithm);
            this.encryptCipher.init(1, specKey);
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Error initializing password encryption: " + exception, exception);
            throw new IzPackException("Failed to initialise password encryption: " + exception.getMessage(), exception);
        }
    }

    private String encryptString(String string) {
        String result;
        try {
            byte[] cryptedbytes = this.encryptCipher.doFinal(string.getBytes("UTF-8"));
            result = Base64.encodeBytes(cryptedbytes);
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Failed to encrypt password: " + exception, exception);
            throw new IzPackException("Failed to encrypt password: " + exception.getMessage(), exception);
        }
        return result;
    }
}

