/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDetails
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "task --details";
    private final Input input;

    public TaskDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                List<TaskTO> notificationTaskTOs = this.taskSyncopeOperations.list(TaskType.NOTIFICATION.name());
                List<TaskTO> propagationTaskTOs = this.taskSyncopeOperations.list(TaskType.PROPAGATION.name());
                List<TaskTO> pushTaskTOs = this.taskSyncopeOperations.list(TaskType.PUSH.name());
                List<TaskTO> scheduledTaskTOs = this.taskSyncopeOperations.list(TaskType.SCHEDULED.name());
                List<TaskTO> pullTaskTOs = this.taskSyncopeOperations.list(TaskType.PULL.name());
                List<JobTO> jobTOs = this.taskSyncopeOperations.listJobs();
                int notificationTaskSize = notificationTaskTOs.size();
                int propagationTaskSize = propagationTaskTOs.size();
                int pushTaskSize = pushTaskTOs.size();
                int scheduledTaskSize = scheduledTaskTOs.size();
                int pullTaskSize = pullTaskTOs.size();
                int jobsSize = jobTOs.size();
                long notificationNotExecuted = notificationTaskTOs.stream().filter(notificationTaskTO -> !((NotificationTaskTO)notificationTaskTO).isExecuted()).count();
                long propagationNotExecuted = propagationTaskTOs.stream().filter(propagationTaskTO -> ((PropagationTaskTO)propagationTaskTO).getExecutions().isEmpty()).count();
                long pushNotExecuted = pushTaskTOs.stream().filter(pushTaskTO -> ((PushTaskTO)pushTaskTO).getExecutions().isEmpty()).count();
                long scheduledNotExecuted = scheduledTaskTOs.stream().filter(scheduledTaskTO -> ((SchedTaskTO)scheduledTaskTO).getExecutions().isEmpty()).count();
                int pullNotExecuted = 0;
                int pullFull = 0;
                for (TaskTO pullTaskTO : pullTaskTOs) {
                    if (((PullTaskTO)pullTaskTO).getExecutions().isEmpty()) {
                        ++pullNotExecuted;
                    }
                    if (((PullTaskTO)pullTaskTO).getPullMode() != PullMode.FULL_RECONCILIATION) continue;
                    ++pullFull;
                }
                details.put("total number", String.valueOf(notificationTaskSize + propagationTaskSize + pushTaskSize + scheduledTaskSize + pullTaskSize));
                details.put("notification tasks", String.valueOf(notificationTaskSize));
                details.put("notification tasks not executed", String.valueOf(notificationNotExecuted));
                details.put("propagation tasks", String.valueOf(propagationTaskSize));
                details.put("propagation tasks not executed", String.valueOf(propagationNotExecuted));
                details.put("push tasks", String.valueOf(pushTaskSize));
                details.put("push tasks not executed", String.valueOf(pushNotExecuted));
                details.put("scheduled tasks", String.valueOf(scheduledTaskSize));
                details.put("scheduled tasks not executed", String.valueOf(scheduledNotExecuted));
                details.put("pull tasks", String.valueOf(pullTaskSize));
                details.put("pull tasks not executed", String.valueOf(pullNotExecuted));
                details.put("pull tasks with full reconciliation", String.valueOf(pullFull));
                details.put("jobs", String.valueOf(jobsSize));
                this.taskResultManager.printDetails(details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about task", (Throwable)ex);
                this.taskResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error reading details about task", (Throwable)ex);
                this.taskResultManager.typeNotValidError("task", this.input.firstParameter(), CommandUtils.fromEnumToArray(TaskType.class));
            }
        } else {
            this.taskResultManager.commandOptionError(DETAILS_HELP_MESSAGE);
        }
    }
}

