/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import java.util.LinkedHashMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.policy.AbstractPolicyCommand;
import org.apache.syncope.common.lib.types.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDetails
extends AbstractPolicyCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "policy --details";
    private final Input input;

    public PolicyDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                int accountPolicySize = this.policySyncopeOperations.list(PolicyType.ACCOUNT.name()).size();
                int passwordPolicySize = this.policySyncopeOperations.list(PolicyType.PASSWORD.name()).size();
                int pullPolicySize = this.policySyncopeOperations.list(PolicyType.PULL.name()).size();
                int pushPolicySize = this.policySyncopeOperations.list(PolicyType.PUSH.name()).size();
                details.put("total number", String.valueOf(accountPolicySize + passwordPolicySize + pullPolicySize + pushPolicySize));
                details.put("account policies", String.valueOf(accountPolicySize));
                details.put("password policies", String.valueOf(passwordPolicySize));
                details.put("pull policies", String.valueOf(pullPolicySize));
                details.put("push policies", String.valueOf(pushPolicySize));
                this.policyResultManager.printDetails(details);
            }
            catch (Exception ex) {
                LOG.error("Error reading details about policy", (Throwable)ex);
                this.policyResultManager.genericError(ex.getMessage());
            }
        } else {
            this.policyResultManager.commandOptionError(DETAILS_HELP_MESSAGE);
        }
    }
}

