/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.oidc;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OIDCLoginResponseTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.OIDCProviderActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OIDCUserManager {
    private static final Logger LOG = LoggerFactory.getLogger(OIDCUserManager.class);
    @Autowired
    private InboundMatcher inboundMatcher;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private UserProvisioningManager provisioningManager;
    @Autowired
    private UserDataBinder binder;

    @Transactional(readOnly=true)
    public List<String> findMatchingUser(String connObjectKeyValue, OIDCProviderItem connObjectKeyItem) {
        return this.inboundMatcher.matchByConnObjectKeyValue((Item)connObjectKeyItem, connObjectKeyValue, AnyTypeKind.USER, false, null).stream().filter(match -> match.getAny() != null).map(match -> ((User)match.getAny()).getUsername()).collect(Collectors.toList());
    }

    private List<OIDCProviderActions> getActions(OIDCProvider op) {
        ArrayList<OIDCProviderActions> actions = new ArrayList<OIDCProviderActions>();
        op.getActionsClassNames().forEach(className -> {
            try {
                Class<?> actionsClass = Class.forName(className);
                OIDCProviderActions opActions = (OIDCProviderActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(opActions);
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found", className, (Object)e);
            }
        });
        return actions;
    }

    public void fill(OIDCProvider op, OIDCLoginResponseTO responseTO, UserTO userTO) {
        op.getItems().forEach(item -> {
            block19: {
                IntAttrName intAttrName;
                List values;
                block18: {
                    values = Collections.emptyList();
                    Optional oidcAttr = responseTO.getAttr(item.getExtAttrName());
                    if (oidcAttr.isPresent() && !((AttrTO)oidcAttr.get()).getValues().isEmpty()) {
                        values = ((AttrTO)oidcAttr.get()).getValues();
                        List transformed = new ArrayList(values);
                        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)item)) {
                            transformed = transformer.beforePull(null, (EntityTO)userTO, transformed);
                        }
                        values.clear();
                        for (Object value : transformed) {
                            if (value == null) continue;
                            values.add(value.toString());
                        }
                    }
                    intAttrName = null;
                    try {
                        intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.USER);
                    }
                    catch (ParseException e) {
                        LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
                    }
                    if (intAttrName == null || intAttrName.getField() == null) break block18;
                    switch (intAttrName.getField()) {
                        case "username": {
                            if (!values.isEmpty()) {
                                userTO.setUsername((String)values.get(0));
                                break;
                            }
                            break block19;
                        }
                        default: {
                            LOG.warn("Unsupported: {}", (Object)intAttrName.getField());
                            break;
                        }
                    }
                    break block19;
                }
                if (intAttrName != null && intAttrName.getSchemaType() != null) {
                    switch (intAttrName.getSchemaType()) {
                        case PLAIN: {
                            Optional<AttrTO> attr = userTO.getPlainAttr(intAttrName.getSchema().getKey());
                            if (attr.isPresent()) {
                                ((AttrTO)attr.get()).getValues().clear();
                            } else {
                                attr = Optional.of(new AttrTO.Builder().schema(intAttrName.getSchema().getKey()).build());
                                userTO.getPlainAttrs().add(attr.get());
                            }
                            ((AttrTO)attr.get()).getValues().addAll(values);
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported: {} {}", (Object)intAttrName.getSchemaType(), (Object)intAttrName.getSchema().getKey());
                        }
                    }
                }
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String create(OIDCProvider op, OIDCLoginResponseTO responseTO, String email) {
        UserTO userTO = new UserTO();
        if (op.getUserTemplate() != null && op.getUserTemplate().get() != null) {
            this.templateUtils.apply((AnyTO)userTO, op.getUserTemplate().get());
        }
        List<OIDCProviderActions> actions = this.getActions(op);
        for (OIDCProviderActions action : actions) {
            userTO = action.beforeCreate(userTO, responseTO);
        }
        this.fill(op, responseTO, userTO);
        if (userTO.getRealm() == null) {
            userTO.setRealm("/");
        }
        if (userTO.getUsername() == null) {
            userTO.setUsername(email);
        }
        Pair created = this.provisioningManager.create(userTO, false, false);
        userTO = this.binder.getUserTO((String)created.getKey());
        for (OIDCProviderActions action : actions) {
            userTO = action.afterCreate(userTO, responseTO);
        }
        return userTO.getUsername();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String update(String username, OIDCProvider op, OIDCLoginResponseTO responseTO) {
        UserTO userTO = this.binder.getUserTO(this.userDAO.findKey(username));
        UserTO original = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.fill(op, responseTO, userTO);
        UserPatch userPatch = AnyOperations.diff((UserTO)userTO, (UserTO)original, (boolean)true);
        List<OIDCProviderActions> actions = this.getActions(op);
        for (OIDCProviderActions action : actions) {
            userPatch = action.beforeUpdate(userPatch, responseTO);
        }
        Pair updated = this.provisioningManager.update((AnyPatch)userPatch, false);
        userTO = this.binder.getUserTO(((UserPatch)updated.getLeft()).getKey());
        for (OIDCProviderActions action : actions) {
            userTO = action.afterUpdate(userTO, responseTO);
        }
        return userTO.getUsername();
    }
}

