/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public class JweJwtCompactConsumer {
    private JweCompactConsumer jweConsumer;
    private JweHeaders headers;

    public JweJwtCompactConsumer(String content) {
        this.jweConsumer = new JweCompactConsumer(content);
        this.headers = this.jweConsumer.getJweHeaders();
    }

    public JwtToken decryptWith(JsonWebKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(PrivateKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getKeyEncryptionAlgorithm(), this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(SecretKey key) {
        return this.decryptWith(JweUtils.createJweDecryptionProvider(key, this.headers.getKeyEncryptionAlgorithm(), this.headers.getContentEncryptionAlgorithm()));
    }

    public JwtToken decryptWith(JweDecryptionProvider jwe) {
        byte[] bytes = jwe.decrypt(this.jweConsumer.getJweDecryptionInput());
        JwtClaims claims = JwtUtils.jsonToClaims(JweJwtCompactConsumer.toString(bytes));
        return new JwtToken(this.headers, claims);
    }

    public JweHeaders getHeaders() {
        return this.headers;
    }

    private static String toString(byte[] bytes) {
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

