/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.policy.InvalidPasswordRuleConf;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnObjectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnObjectUtils.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private PasswordGenerator passwordGenerator;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    public static String getPassword(Object pwd) {
        StringBuilder result = new StringBuilder();
        if (pwd instanceof GuardedString) {
            result.append(SecurityUtil.decrypt((GuardedString)((GuardedString)pwd)));
        } else if (pwd instanceof GuardedByteArray) {
            result.append(SecurityUtil.decrypt((GuardedByteArray)((GuardedByteArray)pwd)));
        } else if (pwd instanceof String) {
            result.append((String)pwd);
        } else {
            result.append(pwd.toString());
        }
        return result.toString();
    }

    public static ConnObjectTO getConnObjectTO(Set<Attribute> attrs) {
        ConnObjectTO connObjectTO = new ConnObjectTO();
        if (attrs != null) {
            connObjectTO.getAttrs().addAll(attrs.stream().map(attr -> {
                AttrTO attrTO = new AttrTO();
                attrTO.setSchema(attr.getName());
                if (attr.getValue() != null) {
                    attr.getValue().stream().filter(value -> value != null).forEachOrdered(value -> {
                        if (value instanceof GuardedString || value instanceof GuardedByteArray) {
                            attrTO.getValues().add(ConnObjectUtils.getPassword(value));
                        } else if (value instanceof byte[]) {
                            attrTO.getValues().add(Base64.getEncoder().encodeToString((byte[])value));
                        } else if (value != null) {
                            attrTO.getValues().add(value.toString());
                        }
                    });
                }
                return attrTO;
            }).collect(Collectors.toList()));
        }
        return connObjectTO;
    }

    @Transactional(readOnly=true)
    public <T extends AnyTO> T getAnyTO(ConnectorObject obj, PullTask pullTask, Provision provision, boolean generatePasswordIfPossible) {
        T anyTO = this.getAnyTOFromConnObject(obj, pullTask, provision);
        if (anyTO instanceof UserTO && StringUtils.isBlank((CharSequence)((UserTO)anyTO).getPassword()) && generatePasswordIfPossible && provision.getResource().isRandomPwdIfNotProvided()) {
            String password;
            UserTO userTO = (UserTO)anyTO;
            ArrayList passwordPolicies = new ArrayList();
            Realm realm = this.realmDAO.findByFullPath(userTO.getRealm());
            if (realm != null) {
                this.realmDAO.findAncestors(realm).stream().filter(ancestor -> ancestor.getPasswordPolicy() != null).forEach(ancestor -> passwordPolicies.add(ancestor.getPasswordPolicy()));
            }
            userTO.getResources().stream().map(resource -> this.resourceDAO.find(resource)).filter(resource -> resource != null && resource.getPasswordPolicy() != null).forEach(resource -> passwordPolicies.add(resource.getPasswordPolicy()));
            try {
                password = this.passwordGenerator.generate(passwordPolicies);
            }
            catch (InvalidPasswordRuleConf e) {
                LOG.error("Could not generate policy-compliant random password for {}", (Object)userTO, (Object)e);
                password = SecureRandomUtils.generateRandomPassword((int)16);
            }
            userTO.setPassword(password);
        }
        return anyTO;
    }

    public RealmTO getRealmTO(ConnectorObject obj, PullTask task, OrgUnit orgUnit) {
        RealmTO realmTO = new RealmTO();
        MappingUtils.getPullItems(orgUnit.getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), realmTO));
        return realmTO;
    }

    @Transactional(readOnly=true)
    public <T extends AnyPatch> T getAnyPatch(String key, ConnectorObject obj, AnyTO original, PullTask pullTask, Provision provision) {
        T updated = this.getAnyTOFromConnObject(obj, pullTask, provision);
        updated.setKey(key);
        AnyObjectPatch anyPatch = null;
        switch (provision.getAnyType().getKind()) {
            case USER: {
                UserTO originalUser = (UserTO)original;
                UserTO updatedUser = (UserTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedUser.getUsername())) {
                    updatedUser.setUsername(originalUser.getUsername());
                }
                User user = (User)this.userDAO.authFind(key);
                if (StringUtils.isBlank((CharSequence)updatedUser.getPassword()) || ENCRYPTOR.verify(updatedUser.getPassword(), user.getCipherAlgorithm(), user.getPassword())) {
                    updatedUser.setPassword(null);
                }
                updatedUser.setSecurityQuestion(originalUser.getSecurityQuestion());
                if (!this.mappingManager.hasMustChangePassword(provision)) {
                    updatedUser.setMustChangePassword(originalUser.isMustChangePassword());
                }
                anyPatch = AnyOperations.diff((UserTO)updatedUser, (UserTO)originalUser, (boolean)true);
                break;
            }
            case GROUP: {
                GroupTO originalGroup = (GroupTO)original;
                GroupTO updatedGroup = (GroupTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedGroup.getName())) {
                    updatedGroup.setName(originalGroup.getName());
                }
                updatedGroup.setUserOwner(originalGroup.getUserOwner());
                updatedGroup.setGroupOwner(originalGroup.getGroupOwner());
                updatedGroup.setUDynMembershipCond(originalGroup.getUDynMembershipCond());
                updatedGroup.getADynMembershipConds().putAll(originalGroup.getADynMembershipConds());
                updatedGroup.getTypeExtensions().addAll(originalGroup.getTypeExtensions());
                anyPatch = AnyOperations.diff((GroupTO)updatedGroup, (GroupTO)originalGroup, (boolean)true);
                break;
            }
            case ANY_OBJECT: {
                AnyObjectTO originalAnyObject = (AnyObjectTO)original;
                AnyObjectTO updatedAnyObject = (AnyObjectTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedAnyObject.getName())) {
                    updatedAnyObject.setName(originalAnyObject.getName());
                }
                anyPatch = AnyOperations.diff((AnyObjectTO)updatedAnyObject, (AnyObjectTO)originalAnyObject, (boolean)true);
                break;
            }
        }
        if (anyPatch != null) {
            anyPatch.setRealm(null);
            AnyOperations.cleanEmptyAttrs(updated, anyPatch);
        }
        return (T)anyPatch;
    }

    private <T extends AnyTO> T getAnyTOFromConnObject(ConnectorObject obj, PullTask pullTask, Provision provision) {
        AnyTO anyTO = this.anyUtilsFactory.getInstance(provision.getAnyType().getKind()).newAnyTO();
        anyTO.setType(provision.getAnyType().getKey());
        anyTO.getAuxClasses().addAll(provision.getAuxClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
        anyTO.setRealm(pullTask.getDestinatioRealm().getFullPath());
        MappingUtils.getPullItems(provision.getMapping().getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), anyTO));
        this.templateUtils.apply(anyTO, pullTask.getTemplate(provision.getAnyType()));
        return (T)anyTO;
    }
}

