/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPushExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamAnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamGroupPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamUserPushResultHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ImplementationManager;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamPushJobDelegate
extends PushJobDelegate
implements SyncopeStreamPushExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;

    @Override
    protected AnyObjectPushResultHandler buildAnyObjectHandler() {
        return (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamAnyObjectPushResultHandler.class, 1, false);
    }

    @Override
    protected UserPushResultHandler buildUserHandler() {
        return (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamUserPushResultHandler.class, 1, false);
    }

    @Override
    protected GroupPushResultHandler buildGroupHandler() {
        return (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamGroupPushResultHandler.class, 1, false);
    }

    private ExternalResource externalResource(AnyType anyType, List<String> columns, List<String> propagationActions) throws JobExecutionException {
        Provision provision = (Provision)this.entityFactory.newEntity(Provision.class);
        provision.setAnyType(anyType);
        provision.setObjectClass(new ObjectClass(anyType.getKey()));
        Mapping mapping = (Mapping)this.entityFactory.newEntity(Mapping.class);
        provision.setMapping(mapping);
        mapping.setProvision(provision);
        MappingItem connObjectKeyItem = (MappingItem)this.entityFactory.newEntity(MappingItem.class);
        connObjectKeyItem.setExtAttrName("key");
        connObjectKeyItem.setIntAttrName("key");
        connObjectKeyItem.setPurpose(MappingPurpose.NONE);
        mapping.setConnObjectKeyItem(connObjectKeyItem);
        columns.stream().map(column -> {
            MappingItem item = (MappingItem)this.entityFactory.newEntity(MappingItem.class);
            item.setExtAttrName(column);
            item.setIntAttrName(column);
            item.setPurpose(MappingPurpose.PROPAGATION);
            mapping.add(item);
            return item;
        }).forEach(arg_0 -> ((Mapping)mapping).add(arg_0));
        ExternalResource resource = (ExternalResource)this.entityFactory.newEntity(ExternalResource.class);
        resource.setKey("Stream_" + SecureRandomUtils.generateRandomUUID().toString());
        resource.add(provision);
        provision.setResource(resource);
        propagationActions.forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PROPAGATION_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                resource.add(impl);
            }
        });
        return resource;
    }

    public List<ProvisioningReport> push(AnyType anyType, List<? extends Any<?>> anys, List<String> columns, Connector connector, List<String> propagationActions, PushTaskTO pushTaskTO) throws JobExecutionException {
        LOG.debug("Executing stream push");
        ArrayList pushActions = new ArrayList();
        pushTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PUSH_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    pushActions.add(ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        try {
            UserPushResultHandler handler;
            ExternalResource resource = this.externalResource(anyType, columns, propagationActions);
            Provision provision = (Provision)resource.getProvisions().get(0);
            PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
            pushTask.setResource(resource);
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule());
            pushTask.setPerformCreate(true);
            pushTask.setPerformUpdate(true);
            pushTask.setPerformDelete(true);
            pushTask.setSyncStatus(false);
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
            this.profile.getActions().addAll(pushActions);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            for (PushActions action : pushActions) {
                action.beforeAll(this.profile);
            }
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(anys, (SyncopePushResultHandler)handler, provision.getResource());
            for (PushActions action : pushActions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While stream pushing", (Throwable)e);
        }
    }
}

