/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPPasswordPullActions
implements PullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPPasswordPullActions.class);
    @Autowired
    protected UserDAO userDAO;
    protected String encodedPassword;
    protected CipherAlgorithm cipher;

    @Transactional(readOnly=true)
    public void beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity) throws JobExecutionException {
        if (entity instanceof UserTO) {
            String password = ((UserTO)entity).getPassword();
            this.parseEncodedPassword(password);
        }
    }

    @Transactional(readOnly=true)
    public <M extends AnyPatch> void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entityTO, M anyPatch) throws JobExecutionException {
        if (anyPatch instanceof UserPatch) {
            PasswordPatch modPassword = ((UserPatch)anyPatch).getPassword();
            this.parseEncodedPassword(modPassword == null ? null : (String)modPassword.getValue());
        }
    }

    protected void parseEncodedPassword(String password) {
        if (password != null && password.startsWith("{")) {
            int closingBracketIndex = password.indexOf(125);
            String digest = password.substring(1, password.indexOf(125));
            if (digest != null) {
                digest = digest.toUpperCase();
            }
            try {
                this.encodedPassword = password.substring(closingBracketIndex + 1);
                this.cipher = CipherAlgorithm.valueOf((String)digest);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)digest, (Object)e);
                this.encodedPassword = null;
            }
        }
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (entity instanceof UserTO && this.encodedPassword != null && this.cipher != null) {
            User user = (User)this.userDAO.find(entity.getKey());
            if (user != null) {
                byte[] encodedPasswordBytes = Base64.getDecoder().decode(this.encodedPassword.getBytes());
                String encodedHexStr = DatatypeConverter.printHexBinary((byte[])encodedPasswordBytes).toUpperCase();
                user.setEncodedPassword(encodedHexStr, this.cipher);
            }
            this.encodedPassword = null;
            this.cipher = null;
        }
    }
}

