/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.report.AuditReportletConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.job.report.AbstractReportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=AuditReportletConf.class)
public class AuditReportlet
extends AbstractReportlet {
    @Autowired
    private DomainsHolder domainsHolder;
    private AuditReportletConf conf;
    private DataSource datasource;

    private void doExtractConf(ContentHandler handler, AtomicReference<String> status) throws SAXException {
        status.set("Fetching " + this.conf.getSize() + " rows from the " + "SYNCOPEAUDIT" + " table");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.datasource);
        jdbcTemplate.setMaxRows(this.conf.getSize());
        List rows = jdbcTemplate.queryForList("SELECT * FROM SYNCOPEAUDIT ORDER BY EVENT_DATE DESC");
        handler.startElement("", "", "events", null);
        AttributesImpl atts = new AttributesImpl();
        for (Map row : rows) {
            Object before;
            AuditEntry auditEntry = (AuditEntry)POJOHelper.deserialize((String)row.get("MESSAGE").toString(), AuditEntry.class);
            atts.clear();
            if (StringUtils.isNotBlank((CharSequence)auditEntry.getWho())) {
                atts.addAttribute("", "", "who", "xsd:string", auditEntry.getWho());
            }
            handler.startElement("", "", "event", atts);
            atts.clear();
            if (StringUtils.isNotBlank((CharSequence)auditEntry.getLogger().getCategory())) {
                atts.addAttribute("", "", "category", "xsd:string", auditEntry.getLogger().getCategory());
            }
            if (StringUtils.isNotBlank((CharSequence)auditEntry.getLogger().getSubcategory())) {
                atts.addAttribute("", "", "subcategory", "xsd:string", auditEntry.getLogger().getSubcategory());
            }
            if (StringUtils.isNotBlank((CharSequence)auditEntry.getLogger().getEvent())) {
                atts.addAttribute("", "", "event", "xsd:string", auditEntry.getLogger().getEvent());
            }
            if (auditEntry.getLogger().getResult() != null) {
                atts.addAttribute("", "", "result", "xsd:string", auditEntry.getLogger().getResult().name());
            }
            handler.startElement("", "", "logger", atts);
            handler.endElement("", "", "logger");
            if (auditEntry.getBefore() != null) {
                before = POJOHelper.serialize((Object)auditEntry.getBefore()).toCharArray();
                handler.startElement("", "", "before", null);
                handler.characters((char[])before, 0, ((char[])before).length);
                handler.endElement("", "", "before");
            }
            if (!auditEntry.getInputs().isEmpty()) {
                handler.startElement("", "", "inputs", null);
                before = auditEntry.getInputs().iterator();
                while (before.hasNext()) {
                    String input = (String)before.next();
                    handler.startElement("", "", "input", null);
                    handler.characters(input.toCharArray(), 0, input.length());
                    handler.endElement("", "", "input");
                }
                handler.endElement("", "", "inputs");
            }
            if (auditEntry.getOutput() != null) {
                char[] output = POJOHelper.serialize((Object)auditEntry.getOutput()).toCharArray();
                handler.startElement("", "", "output", null);
                handler.characters(output, 0, output.length);
                handler.endElement("", "", "output");
            }
            handler.startElement("", "", "throwable", null);
            char[] throwable = row.get("THROWABLE").toString().toCharArray();
            handler.characters(throwable, 0, throwable.length);
            handler.endElement("", "", "throwable");
            handler.endElement("", "", "event");
        }
        handler.endElement("", "", "events");
        status.set("Fetched " + this.conf.getSize() + " rows from the SYNCOPEAUDIT table");
    }

    @Override
    protected void doExtract(ReportletConf conf, ContentHandler handler, AtomicReference<String> status) throws SAXException {
        if (!(conf instanceof AuditReportletConf)) {
            throw new ReportException(new IllegalArgumentException("Invalid configuration provided"));
        }
        this.conf = (AuditReportletConf)AuditReportletConf.class.cast(conf);
        this.datasource = (DataSource)this.domainsHolder.getDomains().get(AuthContextUtils.getDomain());
        if (this.datasource == null) {
            throw new ReportException(new IllegalArgumentException("Could not get to DataSource"));
        }
        this.doExtractConf(handler, status);
    }
}

