/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.MailTemplate;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationDataBinderImpl
implements NotificationDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataBinder.class);
    @Autowired
    private MailTemplateDAO mailTemplateDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public NotificationTO getNotificationTO(Notification notification) {
        NotificationTO notificationTO = new NotificationTO();
        notificationTO.setKey(notification.getKey());
        notificationTO.setTemplate(notification.getTemplate().getKey());
        notificationTO.getEvents().addAll(notification.getEvents());
        notificationTO.setRecipientsFIQL(notification.getRecipientsFIQL());
        notificationTO.getStaticRecipients().addAll(notification.getStaticRecipients());
        notificationTO.setRecipientAttrName(notification.getRecipientAttrName());
        notificationTO.setSelfAsRecipient(notification.isSelfAsRecipient());
        notificationTO.setSender(notification.getSender());
        notificationTO.setSubject(notification.getSubject());
        notificationTO.setTraceLevel(notification.getTraceLevel());
        notificationTO.setActive(notification.isActive());
        notification.getAbouts().forEach(about -> notificationTO.getAbouts().put(about.getAnyType().getKey(), about.get()));
        if (notification.getRecipientsProvider() != null) {
            notificationTO.setRecipientsProvider(notification.getRecipientsProvider().getKey());
        }
        return notificationTO;
    }

    public Notification create(NotificationTO notificationTO) {
        Notification result = (Notification)this.entityFactory.newEntity(Notification.class);
        this.update(result, notificationTO);
        return result;
    }

    public void update(Notification notification, NotificationTO notificationTO) {
        notification.setRecipientsFIQL(notificationTO.getRecipientsFIQL());
        notification.getStaticRecipients().clear();
        notification.getStaticRecipients().addAll(notificationTO.getStaticRecipients());
        notification.setRecipientAttrName(notificationTO.getRecipientAttrName());
        notification.setSelfAsRecipient(notificationTO.isSelfAsRecipient());
        notification.setSender(notificationTO.getSender());
        notification.setSubject(notificationTO.getSubject());
        notification.setTraceLevel(notificationTO.getTraceLevel());
        notification.setActive(notificationTO.isActive());
        notification.getEvents().clear();
        notification.getEvents().addAll(notificationTO.getEvents());
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        MailTemplate template = this.mailTemplateDAO.find(notificationTO.getTemplate());
        if (template == null) {
            sce.getElements().add("template");
        }
        notification.setTemplate(template);
        if (notification.getEvents().isEmpty()) {
            sce.getElements().add("events");
        }
        if (!notification.getStaticRecipients().isEmpty()) {
            notification.getStaticRecipients().forEach(mail -> {
                Matcher matcher = SyncopeConstants.EMAIL_PATTERN.matcher((CharSequence)mail);
                if (!matcher.matches()) {
                    LOG.error("Invalid mail address: {}", mail);
                    sce.getElements().add("staticRecipients: " + mail);
                }
            });
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        notificationTO.getAbouts().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEachOrdered(entry -> {
            AnyType anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
            } else {
                AnyAbout about = notification.getAbout(anyType).orElse(null);
                if (about == null) {
                    about = (AnyAbout)this.entityFactory.newEntity(AnyAbout.class);
                    about.setAnyType(anyType);
                    about.setNotification(notification);
                    notification.add(about);
                }
                about.set((String)entry.getValue());
            }
        });
        notification.getAbouts().removeIf(anyAbout -> !notificationTO.getAbouts().containsKey(anyAbout.getAnyType().getKey()));
        try {
            this.intAttrNameParser.parse(notification.getRecipientAttrName(), AnyTypeKind.USER);
        }
        catch (ParseException e) {
            SyncopeClientException invalidRequest = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            invalidRequest.getElements().add(e.getMessage());
            throw invalidRequest;
        }
        if (notificationTO.getRecipientsProvider() == null) {
            notification.setRecipientsProvider(null);
        } else {
            Implementation recipientsProvider = this.implementationDAO.find(notificationTO.getRecipientsProvider());
            if (recipientsProvider == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", (Object)notificationTO.getRecipientsProvider());
            } else {
                notification.setRecipientsProvider(recipientsProvider);
            }
        }
    }
}

