/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.Validator;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.LogicActions;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.RecipientsProvider;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImplementationDataBinderImpl
implements ImplementationDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationDataBinder.class);
    @Autowired
    private EntityFactory entityFactory;

    public Implementation create(ImplementationTO implementationTO) {
        Implementation implementation = (Implementation)this.entityFactory.newEntity(Implementation.class);
        this.update(implementation, implementationTO);
        return implementation;
    }

    public void update(Implementation implementation, ImplementationTO implementationTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
        if (implementation.getType() != null && implementation.getType() != implementationTO.getType()) {
            sce.getElements().add("ImplementationType cannot be changed");
            throw sce;
        }
        if (StringUtils.isBlank((CharSequence)implementationTO.getBody())) {
            sce.getElements().add("No actual implementation provided");
            throw sce;
        }
        implementation.setKey(implementationTO.getKey());
        implementation.setEngine(implementationTO.getEngine());
        implementation.setType(implementationTO.getType());
        implementation.setBody(implementationTO.getBody());
        if (implementation.getEngine() == ImplementationEngine.JAVA) {
            Class<Reportlet> base = null;
            switch (implementation.getType()) {
                case REPORTLET: {
                    base = Reportlet.class;
                    break;
                }
                case ACCOUNT_RULE: {
                    base = AccountRule.class;
                    break;
                }
                case PASSWORD_RULE: {
                    base = PasswordRule.class;
                    break;
                }
                case ITEM_TRANSFORMER: {
                    base = ItemTransformer.class;
                    break;
                }
                case TASKJOB_DELEGATE: {
                    base = SchedTaskJobDelegate.class;
                    break;
                }
                case RECON_FILTER_BUILDER: {
                    base = ReconFilterBuilder.class;
                    break;
                }
                case LOGIC_ACTIONS: {
                    base = LogicActions.class;
                    break;
                }
                case PROPAGATION_ACTIONS: {
                    base = PropagationActions.class;
                    break;
                }
                case PULL_ACTIONS: {
                    base = PullActions.class;
                    break;
                }
                case PUSH_ACTIONS: {
                    base = PushActions.class;
                    break;
                }
                case PULL_CORRELATION_RULE: {
                    base = PullCorrelationRule.class;
                    break;
                }
                case PUSH_CORRELATION_RULE: {
                    base = PushCorrelationRule.class;
                    break;
                }
                case VALIDATOR: {
                    base = Validator.class;
                    break;
                }
                case RECIPIENTS_PROVIDER: {
                    base = RecipientsProvider.class;
                    break;
                }
                case PROVISION_SORTER: {
                    base = ProvisionSorter.class;
                    break;
                }
            }
            if (base == null) {
                sce.getElements().add("No Java interface found for " + implementation.getType());
                throw sce;
            }
            if (implementation.getType() == ImplementationType.REPORTLET) {
                ReportletConf reportlet = (ReportletConf)POJOHelper.deserialize((String)implementation.getBody(), ReportletConf.class);
                if (reportlet == null) {
                    sce.getElements().add("Could not deserialize as ReportletConf");
                    throw sce;
                }
            } else if (implementation.getType() == ImplementationType.ACCOUNT_RULE || implementation.getType() == ImplementationType.PASSWORD_RULE || implementation.getType() == ImplementationType.PULL_CORRELATION_RULE || implementation.getType() == ImplementationType.PUSH_CORRELATION_RULE) {
                RuleConf rule = (RuleConf)POJOHelper.deserialize((String)implementation.getBody(), RuleConf.class);
                if (rule == null) {
                    sce.getElements().add("Could not deserialize as neither Account, Password, Pull nor Push Correlation RuleConf");
                    throw sce;
                }
            } else {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(implementation.getBody());
                }
                catch (Exception e) {
                    LOG.error("Class '{}' not found", (Object)implementation.getBody(), (Object)e);
                    sce.getElements().add("No Java class found: " + implementation.getBody());
                    throw sce;
                }
                if (!base.isAssignableFrom(clazz)) {
                    sce.getElements().add("Java class " + implementation.getBody() + " must comply with " + base.getName());
                    throw sce;
                }
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    sce.getElements().add("Java class " + implementation.getBody() + " is abstract");
                    throw sce;
                }
            }
        }
    }

    public ImplementationTO getImplementationTO(Implementation implementation) {
        ImplementationTO implementationTO = new ImplementationTO();
        implementationTO.setKey(implementation.getKey());
        implementationTO.setEngine(implementation.getEngine());
        implementationTO.setType(implementation.getType());
        implementationTO.setBody(implementation.getBody());
        return implementationTO;
    }
}

