/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnyTypeClassDataBinderImpl
implements AnyTypeClassDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AnyTypeClassDataBinder.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private EntityFactory entityFactory;

    public AnyTypeClass create(AnyTypeClassTO anyTypeClassTO) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.entityFactory.newEntity(AnyTypeClass.class);
        this.update(anyTypeClass, anyTypeClassTO);
        return anyTypeClass;
    }

    public void update(AnyTypeClass anyTypeClass, AnyTypeClassTO anyTypeClassTO) {
        if (anyTypeClass.getKey() == null) {
            anyTypeClass.setKey(anyTypeClassTO.getKey());
        }
        this.plainSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass)).forEach(schema -> schema.setAnyTypeClass(null));
        anyTypeClass.getPlainSchemas().clear();
        anyTypeClassTO.getPlainSchemas().forEach(schemaName -> {
            PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + PlainSchema.class.getSimpleName() + "{}, ignoring...", schemaName);
            } else {
                anyTypeClass.add(schema);
            }
        });
        this.derSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass)).forEach(schema -> schema.setAnyTypeClass(null));
        anyTypeClass.getDerSchemas().clear();
        anyTypeClassTO.getDerSchemas().forEach(schemaName -> {
            DerSchema schema = (DerSchema)this.derSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + DerSchema.class.getSimpleName() + "{}, ignoring...", schemaName);
            } else {
                anyTypeClass.add(schema);
            }
        });
        this.virSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass)).forEach(schema -> schema.setAnyTypeClass(null));
        anyTypeClass.getVirSchemas().clear();
        anyTypeClassTO.getVirSchemas().forEach(schemaName -> {
            VirSchema schema = (VirSchema)this.virSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + VirSchema.class.getSimpleName() + "{}, ignoring...", schemaName);
            } else {
                anyTypeClass.add(schema);
            }
        });
    }

    public AnyTypeClassTO getAnyTypeClassTO(AnyTypeClass anyTypeClass) {
        AnyTypeClassTO anyTypeClassTO = new AnyTypeClassTO();
        anyTypeClassTO.setKey(anyTypeClass.getKey());
        anyTypeClassTO.getInUseByTypes().addAll(this.anyTypeDAO.findByTypeClass(anyTypeClass).stream().map(Entity::getKey).collect(Collectors.toList()));
        anyTypeClassTO.getPlainSchemas().addAll(anyTypeClass.getPlainSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
        anyTypeClassTO.getDerSchemas().addAll(anyTypeClass.getDerSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
        anyTypeClassTO.getVirSchemas().addAll(anyTypeClass.getVirSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
        return anyTypeClassTO;
    }
}

