/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobCompatibilityManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteJobCmd
implements Command<Object>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteJobCmd.class);
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String jobId;

    public DeleteJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Object execute(CommandContext commandContext) {
        JobEntity jobToDelete = this.getJobToDelete(commandContext);
        InternalJobCompatibilityManager internalJobCompatibilityManager = this.jobServiceConfiguration.getInternalJobCompatibilityManager();
        if (internalJobCompatibilityManager != null && internalJobCompatibilityManager.isFlowable5Job(jobToDelete)) {
            internalJobCompatibilityManager.deleteV5Job(jobToDelete.getId());
            return null;
        }
        this.sendCancelEvent(jobToDelete);
        this.jobServiceConfiguration.getJobEntityManager().delete(jobToDelete);
        return null;
    }

    protected void sendCancelEvent(JobEntity jobToDelete) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, jobToDelete), this.jobServiceConfiguration.getEngineName());
        }
    }

    protected JobEntity getJobToDelete(CommandContext commandContext) {
        JobEntity job;
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting job {}", (Object)this.jobId);
        }
        if ((job = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().findById(this.jobId)) == null) {
            throw new FlowableObjectNotFoundException("No job found with id '" + this.jobId + "'", Job.class);
        }
        if (job.getLockOwner() != null) {
            throw new FlowableException("Cannot delete job when the job is being executed. Try again later.");
        }
        return job;
    }
}

