/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AcquiredTimerJobEntities;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class AcquireTimerJobsCmd
implements Command<AcquiredTimerJobEntities> {
    private final AsyncExecutor asyncExecutor;

    public AcquireTimerJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public AcquiredTimerJobEntities execute(CommandContext commandContext) {
        AcquiredTimerJobEntities acquiredJobs = new AcquiredTimerJobEntities();
        JobServiceConfiguration jobServiceConfiguration = this.asyncExecutor.getJobServiceConfiguration();
        List<String> enabledCategories = jobServiceConfiguration.getEnabledJobCategories();
        List timerJobs = jobServiceConfiguration.getTimerJobEntityManager().findJobsToExecute(enabledCategories, new Page(0, this.asyncExecutor.getMaxTimerJobsPerAcquisition()));
        for (TimerJobEntity job : timerJobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis(), jobServiceConfiguration);
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, TimerJobEntity job, int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

