/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.core.Response;
import net.tirasa.connid.bundles.servicenow.SNConnectorConfiguration;
import net.tirasa.connid.bundles.servicenow.dto.Resource;
import net.tirasa.connid.bundles.servicenow.service.NoSuchEntityException;
import net.tirasa.connid.bundles.servicenow.utils.SNUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;

public class SNService {
    private static final Log LOG = Log.getLog(SNService.class);
    protected final SNConnectorConfiguration config;
    public static final String RESPONSE_RESULT = "result";
    public static final String RESPONSE_HEADER_TOTAL_COUNT = "x-total-count";

    public SNService(SNConnectorConfiguration config) {
        this.config = config;
    }

    public WebClient getWebclient(ResourceTable table, Map<String, String> params) {
        WebClient webClient = WebClient.create((String)this.config.getBaseAddress(), (String)this.config.getUsername(), this.config.getPassword() == null ? null : SecurityUtil.decrypt((GuardedString)this.config.getPassword()), null).accept(new String[]{"application/json"}).type("application/json").path((Object)"/api/now/table/").path((Object)table);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                webClient.query(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return webClient;
    }

    public JsonNode doGet(WebClient webClient) {
        LOG.ok("webClient current URL : {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        try {
            Response response = webClient.get();
            this.checkServiceErrors(response);
            result = SNUtils.MAPPER.readTree((String)response.readEntity(String.class));
            if (result.get(RESPONSE_RESULT).isArray()) {
                String totalCount = response.getHeaderString(RESPONSE_HEADER_TOTAL_COUNT);
                if (StringUtil.isNotBlank((String)totalCount)) {
                    ((ObjectNode)result).put("totalCount", String.valueOf(totalCount));
                }
            } else {
                result = result.get(RESPONSE_RESULT);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While retrieving data from ServiceNow", new Object[0]);
        }
        return result;
    }

    protected void doCreate(Resource resource, WebClient webClient) {
        LOG.ok("webClient current URL : {0}", new Object[]{webClient.getCurrentURI()});
        try {
            String payload = SNUtils.MAPPER.writeValueAsString((Object)resource);
            Response response = webClient.post((Object)payload);
            this.checkServiceErrors(response);
            String value = "sys_id";
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode result = SNUtils.MAPPER.readTree(responseAsString);
            if (result.hasNonNull(RESPONSE_RESULT) && result.get(RESPONSE_RESULT).hasNonNull(value)) {
                resource.setSysId(result.get(RESPONSE_RESULT).get(value).textValue());
            } else {
                SNUtils.handleGeneralError("While getting " + value + " value for created Resource - Response : " + responseAsString);
            }
        }
        catch (IOException ex) {
            SNUtils.handleGeneralError("While creating Resource", ex);
        }
    }

    protected JsonNode doUpdate(Resource resource, WebClient webClient) {
        LOG.ok("webClient current URL : {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        WebClient.getConfig((Object)webClient).getRequestContext().put("use.async.http.conduit", true);
        try {
            String payload = SNUtils.MAPPER.writeValueAsString((Object)resource);
            Response response = webClient.invoke("PATCH", (Object)payload);
            this.checkServiceErrors(response);
            String responseAsString = (String)response.readEntity(String.class);
            result = SNUtils.MAPPER.readTree(responseAsString);
            if (result.hasNonNull(RESPONSE_RESULT)) {
                result = result.get(RESPONSE_RESULT);
            } else {
                SNUtils.handleGeneralError("While updating " + resource.getSysId() + " Resource - Response : " + responseAsString);
            }
        }
        catch (IOException ex) {
            SNUtils.handleGeneralError("While updating Resource", ex);
        }
        return result;
    }

    protected void doDelete(String userId, WebClient webClient) {
        LOG.ok("webClient current URL : {0}", new Object[]{webClient.getCurrentURI()});
        int status = webClient.delete().getStatus();
        if (status != Response.Status.NO_CONTENT.getStatusCode() && status != Response.Status.OK.getStatusCode()) {
            throw new NoSuchEntityException(userId);
        }
    }

    private void checkServiceErrors(Response response) {
        if (response == null) {
            SNUtils.handleGeneralError("While executing request - no response");
        } else {
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NoSuchEntityException((String)response.readEntity(String.class));
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.ACCEPTED.getStatusCode() && response.getStatus() != Response.Status.CREATED.getStatusCode()) {
                SNUtils.handleGeneralError("While executing request: " + (String)response.readEntity(String.class));
            }
        }
    }

    public static enum ResourceTable {
        sys_user,
        sys_user_group;

    }
}

