/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.ConditionalPageMasterReference;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageProductionException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.xml.sax.Locator;

public class RepeatablePageMasterAlternatives
extends FObj
implements SubSequenceSpecifier {
    private Property maximumRepeats;
    private static final int INFINITE = -1;
    private int numberConsumed;
    private List<ConditionalPageMasterReference> conditionalPageMasterRefs;
    private boolean hasPagePositionLast;
    private boolean hasPagePositionOnly;

    public RepeatablePageMasterAlternatives(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        this.maximumRepeats = pList.get(156);
    }

    @Override
    public void startOfNode() throws FOPException {
        this.conditionalPageMasterRefs = new ArrayList<ConditionalPageMasterReference>();
        assert (this.parent.getName().equals("fo:page-sequence-master"));
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.parent;
        pageSequenceMaster.addSubsequenceSpecifier(this);
    }

    @Override
    public void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(conditional-page-master-reference+)");
        }
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && !localName.equals("conditional-page-master-reference")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public int getMaximumRepeats() {
        if (this.maximumRepeats.getEnum() == 89) {
            return -1;
        }
        int mr = this.maximumRepeats.getNumeric().getValue();
        if (mr < 0) {
            log.debug((Object)("negative maximum-repeats: " + this.maximumRepeats));
            mr = 0;
        }
        return mr;
    }

    @Override
    public SimplePageMaster getNextPageMaster(boolean isOddPage, boolean isFirstPage, boolean isLastPage, boolean isBlankPage) {
        if (!this.isInfinite() && this.numberConsumed >= this.getMaximumRepeats()) {
            return null;
        }
        ++this.numberConsumed;
        for (ConditionalPageMasterReference cpmr : this.conditionalPageMasterRefs) {
            if (!cpmr.isValid(isOddPage, isFirstPage, isLastPage, isBlankPage)) continue;
            return cpmr.getMaster();
        }
        return null;
    }

    @Override
    public SimplePageMaster getLastPageMaster(boolean isOddPage, boolean isFirstPage, boolean isBlankPage, BlockLevelEventProducer blockLevelEventProducer) {
        for (ConditionalPageMasterReference cpmr : this.conditionalPageMasterRefs) {
            if (!cpmr.isValid(isOddPage, isFirstPage, true, isBlankPage)) continue;
            return cpmr.getMaster();
        }
        blockLevelEventProducer.lastPageMasterReferenceMissing(this, this.getLocator());
        for (ConditionalPageMasterReference cpmr : this.conditionalPageMasterRefs) {
            if (!cpmr.isValid(isOddPage, isFirstPage, false, isBlankPage)) continue;
            return cpmr.getMaster();
        }
        throw new PageProductionException("Last page master not found: oddpage=" + isOddPage + " firstpage=" + isFirstPage + " blankpage=" + isBlankPage);
    }

    public void addConditionalPageMasterReference(ConditionalPageMasterReference cpmr) {
        this.conditionalPageMasterRefs.add(cpmr);
        if (cpmr.getPagePosition() == 72) {
            this.hasPagePositionLast = true;
        }
        if (cpmr.getPagePosition() == 184) {
            this.hasPagePositionOnly = true;
        }
    }

    @Override
    public void reset() {
        this.numberConsumed = 0;
    }

    @Override
    public boolean goToPrevious() {
        if (this.numberConsumed == 0) {
            return false;
        }
        --this.numberConsumed;
        return true;
    }

    @Override
    public boolean hasPagePositionLast() {
        return this.hasPagePositionLast;
    }

    @Override
    public boolean hasPagePositionOnly() {
        return this.hasPagePositionOnly;
    }

    @Override
    public String getLocalName() {
        return "repeatable-page-master-alternatives";
    }

    @Override
    public int getNameId() {
        return 62;
    }

    @Override
    public void resolveReferences(LayoutMasterSet layoutMasterSet) throws ValidationException {
        for (ConditionalPageMasterReference conditionalPageMasterReference : this.conditionalPageMasterRefs) {
            conditionalPageMasterReference.resolveReferences(layoutMasterSet);
        }
    }

    @Override
    public boolean canProcess(String flowName) {
        boolean willTerminate = true;
        ArrayList<ConditionalPageMasterReference> rest = new ArrayList<ConditionalPageMasterReference>();
        for (ConditionalPageMasterReference cpmr : this.conditionalPageMasterRefs) {
            if (!cpmr.isValid(true, false, false, false) && !cpmr.isValid(false, false, false, false)) continue;
            rest.add(cpmr);
        }
        if (!rest.isEmpty()) {
            willTerminate = false;
            for (ConditionalPageMasterReference cpmr : rest) {
                willTerminate |= cpmr.getMaster().getRegion(58).getRegionName().equals(flowName);
            }
        }
        return willTerminate;
    }

    @Override
    public boolean isInfinite() {
        return this.getMaximumRepeats() == -1;
    }

    @Override
    public boolean isReusable() {
        return false;
    }
}

