/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.SSOLoginFormPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.rest.api.service.SAML2IdPService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLSSOLoginFormPanel
extends SSOLoginFormPanel {
    private static final long serialVersionUID = -5252094098970677128L;
    private static final Logger LOG = LoggerFactory.getLogger(SAMLSSOLoginFormPanel.class);

    public SAMLSSOLoginFormPanel(String id) {
        super(id);
        List available = ((SAML2IdPService)SyncopeConsoleSession.get().getAnonymousClient().getService(SAML2IdPService.class)).list();
        final Model model = new Model();
        AjaxDropDownChoicePanel idps = new AjaxDropDownChoicePanel("idps", "SAML 2.0", (IModel)model, false);
        idps.setChoices(available);
        idps.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SAML2IdPTO>(){
            private static final long serialVersionUID = 1814750973898916102L;

            public Object getDisplayValue(SAML2IdPTO object) {
                return object.getName();
            }

            public String getIdValue(SAML2IdPTO object, int index) {
                return object.getEntityID();
            }

            public SAML2IdPTO getObject(String id, IModel<? extends List<? extends SAML2IdPTO>> choices) {
                return ((List)choices.getObject()).stream().filter(idp -> idp.getEntityID().equals(id)).findFirst().orElse(null);
            }
        });
        idps.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (model.getObject() != null) {
                    try {
                        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new RedirectRequestHandler(UrlUtils.rewriteToContextRelative((String)("saml2sp/login?idp=" + URLEncoder.encode(((SAML2IdPTO)model.getObject()).getEntityID(), StandardCharsets.UTF_8.name())), (IRequestCycle)RequestCycle.get())));
                    }
                    catch (Exception e) {
                        LOG.error("Could not redirect to the selected IdP {}", (Object)((SAML2IdPTO)model.getObject()).getEntityID(), (Object)e);
                    }
                }
            }
        }});
        idps.setOutputMarkupPlaceholderTag(true);
        idps.setVisible(!available.isEmpty());
        this.add(new Component[]{idps});
    }
}

