/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class CreateProducer
extends AbstractProducer {
    public CreateProducer(Endpoint endpoint, AnyTypeKind anyTypeKind) {
        super(endpoint, anyTypeKind);
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getIn().getBody() instanceof WorkflowResult) {
            Object actual = exchange.getProperty("actual");
            Set excludedResources = (Set)exchange.getProperty("excludedResources", Set.class);
            Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
            if (actual instanceof UserTO) {
                UserWorkflowResult created = (UserWorkflowResult)exchange.getIn().getBody();
                List taskInfos = this.getPropagationManager().getUserCreateTasks((String)((Pair)created.getResult()).getKey(), ((UserTO)actual).getPassword(), (Boolean)((Pair)created.getResult()).getValue(), created.getPropByRes(), created.getPropByLinkedAccount(), (Collection)((UserTO)actual).getVirAttrs(), (Collection)excludedResources);
                PropagationReporter reporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
                exchange.getOut().setBody((Object)Pair.of((Object)((Pair)created.getResult()).getKey(), (Object)reporter.getStatuses()));
            } else if (actual instanceof AnyTO) {
                WorkflowResult created = (WorkflowResult)exchange.getIn().getBody();
                if (actual instanceof GroupTO && this.isPull()) {
                    Map groupOwnerMap = (Map)exchange.getProperty("groupOwnerMap", Map.class);
                    ((GroupTO)actual).getPlainAttr("").ifPresent(groupOwner -> {
                        String cfr_ignored_0 = (String)groupOwnerMap.put(created.getResult(), groupOwner.getValues().iterator().next());
                    });
                    List taskInfos = this.getPropagationManager().getCreateTasks(AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), (Collection)((AnyTO)actual).getVirAttrs(), (Collection)excludedResources);
                    this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
                    exchange.getOut().setBody((Object)Pair.of((Object)created.getResult(), null));
                } else {
                    List taskInfos = this.getPropagationManager().getCreateTasks(actual instanceof AnyObjectTO ? AnyTypeKind.ANY_OBJECT : AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), (Collection)((AnyTO)actual).getVirAttrs(), (Collection)excludedResources);
                    PropagationReporter reporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
                    exchange.getOut().setBody((Object)Pair.of((Object)created.getResult(), (Object)reporter.getStatuses()));
                }
            }
        }
    }
}

