/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table.util;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.tirasa.connid.bundles.db.table.mapping.MappingStrategy;
import net.tirasa.connid.commons.db.SQLParam;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;

public final class DatabaseTableSQLUtil {
    private static final Log LOG = Log.getLog(DatabaseTableSQLUtil.class);

    private DatabaseTableSQLUtil() {
        throw new AssertionError();
    }

    public static void setParams(MappingStrategy sms, PreparedStatement statement, List<SQLParam> params) throws SQLException {
        if (statement == null || params == null) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            int idx = i + 1;
            SQLParam parm = params.get(i);
            DatabaseTableSQLUtil.setParam(sms, statement, idx, parm);
        }
    }

    public static void setParams(MappingStrategy sms, CallableStatement statement, List<SQLParam> params) throws SQLException {
        DatabaseTableSQLUtil.setParams(sms, (PreparedStatement)statement, params);
    }

    static void setParam(MappingStrategy sms, PreparedStatement stmt, int idx, SQLParam parm) throws SQLException {
        if (parm.getValue() instanceof GuardedString) {
            DatabaseTableSQLUtil.setGuardedStringParam(sms, stmt, idx, parm);
        } else {
            sms.setSQLParam(stmt, idx, parm);
        }
    }

    public static Map<String, SQLParam> getColumnValues(MappingStrategy sms, ResultSet resultSet) throws SQLException {
        Assertions.nullCheck((Object)resultSet, (String)"resultSet");
        SortedMap ret = CollectionUtil.newCaseInsensitiveMap();
        ResultSetMetaData meta = resultSet.getMetaData();
        int count = meta.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            SQLParam param = sms.getSQLParam(resultSet, i, name, sqlType);
            ret.put(name, param);
        }
        return ret;
    }

    static void setGuardedStringParam(final MappingStrategy sms, final PreparedStatement stmt, final int idx, SQLParam param) throws SQLException {
        GuardedString guard = (GuardedString)param.getValue();
        final String name = param.getName();
        try {
            guard.access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    try {
                        sms.setSQLParam(stmt, idx, new SQLParam(name, (Object)new String(clearChars), 12));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    public static String quoteName(String quoting, String value) {
        StringBuilder bld = new StringBuilder();
        if (StringUtil.isBlank((String)quoting) || "none".equalsIgnoreCase(quoting)) {
            bld.append(value);
        } else if ("double".equalsIgnoreCase(quoting)) {
            bld.append('\"').append(value).append('\"');
        } else if ("single".equalsIgnoreCase(quoting)) {
            bld.append('\'').append(value).append('\'');
        } else if ("back".equalsIgnoreCase(quoting)) {
            bld.append('`').append(value).append('`');
        } else if ("brackets".equalsIgnoreCase(quoting)) {
            bld.append('[').append(value).append(']');
        } else {
            throw new IllegalArgumentException();
        }
        return bld.toString();
    }

    public static long tsAsLong(String ts) {
        long time = ts.matches("\\d\\d:\\d\\d:\\d\\d") ? Time.valueOf(ts).getTime() : (ts.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d") ? Date.valueOf(ts).getTime() : Timestamp.valueOf(ts).getTime());
        return time;
    }
}

