/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.provisioning.api.data.ApplicationDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ApplicationLogic
extends AbstractTransactionalLogic<ApplicationTO> {
    @Autowired
    private ApplicationDataBinder binder;
    @Autowired
    private ApplicationDAO applicationDAO;

    @PreAuthorize(value="hasRole('APPLICATION_READ')")
    @Transactional(readOnly=true)
    public ApplicationTO read(String key) {
        Application application = this.applicationDAO.find(key);
        if (application == null) {
            LOG.error("Could not find application '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getApplicationTO(application);
    }

    @PreAuthorize(value="hasRole('APPLICATION_READ')")
    @Transactional(readOnly=true)
    public PrivilegeTO readPrivilege(String key) {
        Privilege privilege = this.applicationDAO.findPrivilege(key);
        if (privilege == null) {
            LOG.error("Could not find privilege '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getPrivilegeTO(privilege);
    }

    @PreAuthorize(value="hasRole('APPLICATION_LIST')")
    @Transactional(readOnly=true)
    public List<ApplicationTO> list() {
        return this.applicationDAO.findAll().stream().map(arg_0 -> ((ApplicationDataBinder)this.binder).getApplicationTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('APPLICATION_CREATE')")
    public ApplicationTO create(ApplicationTO applicationTO) {
        return this.binder.getApplicationTO(this.applicationDAO.save(this.binder.create(applicationTO)));
    }

    @PreAuthorize(value="hasRole('APPLICATION_UPDATE')")
    public ApplicationTO update(ApplicationTO applicationTO) {
        Application application = this.applicationDAO.find(applicationTO.getKey());
        if (application == null) {
            LOG.error("Could not find application '" + applicationTO.getKey() + "'");
            throw new NotFoundException(applicationTO.getKey());
        }
        return this.binder.getApplicationTO(this.applicationDAO.save(this.binder.update(application, applicationTO)));
    }

    @PreAuthorize(value="hasRole('APPLICATION_DELETE')")
    public ApplicationTO delete(String key) {
        Application application = this.applicationDAO.find(key);
        if (application == null) {
            LOG.error("Could not find application '" + key + "'");
            throw new NotFoundException(key);
        }
        ApplicationTO deleted = this.binder.getApplicationTO(application);
        this.applicationDAO.delete(key);
        return deleted;
    }

    @Override
    protected ApplicationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ApplicationTO)) continue;
                key = ((ApplicationTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getApplicationTO(this.applicationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

