/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;

public class AttributeValue {
    private final List<Object> value;

    public AttributeValue(List<Object> value) {
        this.value = value == null || value.isEmpty() ? null : value;
    }

    public AttributeValue(String strValue, String multivaluDelimiter) {
        if (StringUtil.isBlank((String)strValue)) {
            this.value = null;
        } else if (StringUtil.isBlank((String)multivaluDelimiter)) {
            this.value = new ArrayList<Object>();
            this.value.add(strValue);
        } else {
            this.value = new ArrayList<String>(Arrays.asList(strValue.split(Pattern.quote(multivaluDelimiter), -1)));
        }
    }

    public Boolean toBoolean() {
        return this.value == null ? null : (Boolean)Boolean.class.cast(this.value.get(0));
    }

    public String toSecureString() {
        if (this.value == null) {
            return "";
        }
        final ArrayList res = new ArrayList();
        ((GuardedString)this.value.get(0)).access(new GuardedString.Accessor(){

            public void access(char[] clearChars) {
                res.add(new String(clearChars));
            }
        });
        return (String)res.get(0);
    }

    public String toString() {
        return this.value == null ? null : this.value.get(0).toString();
    }

    public String toString(String multivaluDelimiter) {
        if (this.value == null) {
            return null;
        }
        if (StringUtil.isBlank((String)multivaluDelimiter)) {
            return this.toString();
        }
        StringBuilder bld = new StringBuilder();
        for (Object item : this.value) {
            if (bld.length() > 0) {
                bld.append(multivaluDelimiter);
            }
            bld.append(item.toString().trim());
        }
        return bld.toString();
    }

    public List<Object> get() {
        return this.value;
    }
}

