/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.wizard;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.resource.StyleSheetPackageHeaderItem;
import com.googlecode.wicket.jquery.ui.panel.JQueryFeedbackPanel;
import com.googlecode.wicket.jquery.ui.widget.dialog.AbstractFormDialog;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.IWizardModelListener;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractWizard<T extends Serializable>
extends AbstractFormDialog<T>
implements IWizardModelListener,
IWizard {
    private static final long serialVersionUID = 1L;
    private IWizardModel wizardModel;
    private Form<T> form;
    private WebMarkupContainer feedback;
    private DialogButton btnPrev;
    private DialogButton btnNext;
    private DialogButton btnLast;
    private DialogButton btnFinish;
    private DialogButton btnCancel;

    public AbstractWizard(String id, String title) {
        super(id, title);
    }

    public AbstractWizard(String id, IModel<String> title) {
        super(id, title);
    }

    public AbstractWizard(String id, String title, IWizardModel wizardModel) {
        super(id, title);
        this.init(wizardModel);
    }

    public AbstractWizard(String id, IModel<String> title, IWizardModel wizardModel) {
        super(id, title);
        this.init(wizardModel);
    }

    public AbstractWizard(String id, String title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractWizard(String id, IModel<String> title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractWizard(String id, String title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public AbstractWizard(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public AbstractWizard(String id, String title, IModel<T> model) {
        super(id, title, model);
    }

    public AbstractWizard(String id, IModel<String> title, IModel<T> model) {
        super(id, title, model);
    }

    protected final void init(IWizardModel wizardModel) {
        Args.notNull((Object)wizardModel, (String)"wizardModel");
        this.wizardModel = wizardModel;
        this.wizardModel.addListener((IWizardModelListener)this);
        this.form = new Form("form");
        this.add(new Component[]{this.form});
        this.form.add(new Component[]{new EmptyPanel("header")});
        this.form.add(new Component[]{new EmptyPanel("view")});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new StyleSheetPackageHeaderItem(AbstractWizard.class));
    }

    protected void reload(IPartialPageRequestHandler handler) {
        this.onConfigure(handler);
        handler.add(new Component[]{this.form});
    }

    public WebMarkupContainer getFeedbackPanel() {
        return this.feedback;
    }

    protected boolean closeOnCancel() {
        return true;
    }

    protected boolean closeOnFinish() {
        return true;
    }

    @Override
    protected void onInitialize() {
        this.feedback = this.newFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
        this.btnPrev = new DialogButton("PREV", this.getString("wizard.button.prev"));
        this.btnNext = new DialogButton("NEXT", this.getString("wizard.button.next"));
        this.btnLast = new DialogButton("LAST", this.getString("wizard.button.last"));
        this.btnFinish = new DialogButton("SUBMIT", this.getString("wizard.button.finish"));
        this.btnCancel = new DialogButton("CANCEL", this.getString("wizard.button.cancel"));
        super.onInitialize();
    }

    @Override
    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
    }

    protected void onConfigure(IPartialPageRequestHandler handler) {
        this.btnPrev.setEnabled(this.wizardModel.isPreviousAvailable(), handler);
        this.btnNext.setEnabled(this.wizardModel.isNextAvailable(), handler);
        this.btnLast.setEnabled(this.wizardModel.isLastAvailable(), handler);
        this.btnLast.setVisible(this.wizardModel.isLastVisible(), handler);
        this.btnCancel.setVisible(this.wizardModel.isCancelVisible(), handler);
        boolean enabled = this.wizardModel.isLastStep(this.wizardModel.getActiveStep());
        this.btnFinish.setEnabled(enabled, handler);
    }

    @Override
    protected void onOpen(IPartialPageRequestHandler handler) {
        super.onOpen(handler);
        this.wizardModel.reset();
        this.reload(handler);
    }

    @Override
    public final void onClick(AjaxRequestTarget target, DialogButton button) {
        if (button.equals(this.getSubmitButton())) {
            this.onFinish();
            this.onFinish(target);
            if (this.closeOnFinish()) {
                this.close((IPartialPageRequestHandler)target, button);
            }
        } else if (button.equals(this.getCancelButton())) {
            this.onCancel();
            this.onCancel(target);
            if (this.closeOnCancel()) {
                this.close((IPartialPageRequestHandler)target, button);
            }
        } else {
            if (button.equals(this.btnPrev)) {
                this.getWizardModel().previous();
            } else if (button.equals(this.btnNext)) {
                this.getWizardModel().next();
            } else if (button.equals(this.btnLast)) {
                this.getWizardModel().last();
            }
            this.reload((IPartialPageRequestHandler)target);
        }
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target, DialogButton button) {
        IWizardModel wizardModel = this.getWizardModel();
        wizardModel.getActiveStep().applyState();
    }

    @Override
    protected final void onError(AjaxRequestTarget target, DialogButton button) {
        target.add(new Component[]{this.feedback});
    }

    public void onFinish() {
    }

    public void onCancel() {
    }

    protected abstract void onFinish(AjaxRequestTarget var1);

    protected void onCancel(AjaxRequestTarget target) {
    }

    public IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public void onActiveStepChanged(IWizardStep step) {
        this.form.replace(step.getHeader("header", (Component)this, (IWizard)this));
        this.form.replace(step.getView("view", (Component)this, (IWizard)this));
    }

    @Override
    protected List<DialogButton> getButtons() {
        return Arrays.asList(this.btnPrev, this.btnNext, this.btnLast, this.btnFinish, this.btnCancel);
    }

    @Override
    public DialogButton getSubmitButton() {
        return this.btnFinish;
    }

    protected DialogButton getCancelButton() {
        return this.btnCancel;
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    @Override
    protected Form<?> getForm(DialogButton button) {
        if (button.equals(this.btnNext) || button.equals(this.btnLast)) {
            return this.getForm();
        }
        return super.getForm(button);
    }

    protected WebMarkupContainer newFeedbackPanel(String id) {
        return new JQueryFeedbackPanel(id);
    }
}

