/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class Index
extends AbstractDatabaseObject {
    public static final String MARK_PRIMARY_KEY = "primaryKey";
    public static final String MARK_FOREIGN_KEY = "foreignKey";
    public static final String MARK_UNIQUE_CONSTRAINT = "uniqueConstraint";

    public Index() {
        this.setAttribute("columns", new ArrayList());
        this.setAttribute("associatedWith", new HashSet());
    }

    public Index(String indexName) {
        this();
        this.setName(indexName);
    }

    public Index(String indexName, String catalogName, String schemaName, String tableName, Column ... columns) {
        this();
        this.setName(indexName);
        if (tableName != null) {
            this.setRelation(new Table(catalogName, schemaName, tableName));
            if (columns != null && columns.length > 0) {
                this.setColumns(Arrays.asList(columns));
            }
        }
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return new DatabaseObject[]{this.getRelation()};
    }

    @Override
    public String getName() {
        return (String)((Object)this.getAttribute("name", String.class));
    }

    @Override
    public Index setName(String name) {
        this.setAttribute("name", name);
        return this;
    }

    @Override
    public Schema getSchema() {
        if (this.getRelation() == null) {
            return null;
        }
        return this.getRelation().getSchema();
    }

    @Deprecated
    public Table getTable() {
        Relation relation = this.getRelation();
        if (relation instanceof Table) {
            return (Table)relation;
        }
        return null;
    }

    @Deprecated
    public Index setTable(Table table) {
        return this.setRelation(table);
    }

    public Relation getRelation() {
        return (Relation)((Object)this.getAttribute("table", Relation.class));
    }

    public Index setRelation(Relation relation) {
        this.setAttribute("table", relation);
        return this;
    }

    public String getTablespace() {
        return (String)((Object)this.getAttribute("tablespace", String.class));
    }

    public Index setTablespace(String tablespace) {
        this.setAttribute("tablespace", tablespace);
        return this;
    }

    public List<Column> getColumns() {
        return (List)((Object)this.getAttribute("columns", List.class));
    }

    public Index addColumn(Column column) {
        column.setRelation(this.getRelation());
        this.getColumns().add(column);
        return this;
    }

    public Index setColumns(List<Column> columns) {
        if (this.getAttribute("table", Object.class) instanceof Table) {
            for (Column column : columns) {
                column.setRelation(this.getRelation());
            }
        }
        this.setAttribute("columns", columns);
        return this;
    }

    public String getColumnNames() {
        return StringUtils.join(this.getColumns(), ", ", (StringUtils.StringUtilsFormatter)new StringUtils.ToStringFormatter());
    }

    public Index setUnique(Boolean value) {
        this.setAttribute("unique", value);
        return this;
    }

    public Boolean isUnique() {
        return (Boolean)((Object)this.getAttribute("unique", Boolean.class));
    }

    public Set<String> getAssociatedWith() {
        return (Set)((Object)this.getAttribute("associatedWith", Set.class));
    }

    public String getAssociatedWithAsString() {
        return StringUtils.join(this.getAssociatedWith(), ",");
    }

    public void addAssociatedWith(String item) {
        this.getAssociatedWith().add(item);
    }

    public boolean isAssociatedWith(String keyword) {
        return this.getAssociatedWith().contains(keyword);
    }

    public Boolean getClustered() {
        return (Boolean)((Object)this.getAttribute("clustered", Boolean.class));
    }

    public Index setClustered(Boolean clustered) {
        return (Index)this.setAttribute("clustered", clustered);
    }

    @Override
    public int compareTo(Object other) {
        Index o = (Index)other;
        int returnValue = 0;
        if (this.getRelation() != null && o.getRelation() != null) {
            returnValue = this.getRelation().compareTo(o.getRelation());
        }
        if (returnValue == 0) {
            String thisName = StringUtils.trimToEmpty(this.getName());
            String oName = StringUtils.trimToEmpty(o.getName());
            returnValue = thisName.compareTo(oName);
        }
        return returnValue;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Index)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() == null ? "(unnamed index)" : this.getName());
        if (this.isUnique() != null && this.isUnique().booleanValue()) {
            stringBuffer.append(" UNIQUE ");
        }
        if (this.getRelation() != null && this.getColumns() != null) {
            String tableName = this.getRelation().getName();
            if (this.getRelation().getSchema() != null && this.getRelation().getSchema().getName() != null) {
                tableName = this.getRelation().getSchema().getName() + "." + tableName;
            }
            stringBuffer.append(" ON ").append(tableName);
            if (this.getColumns() != null && !this.getColumns().isEmpty()) {
                stringBuffer.append("(");
                for (Column column : this.getColumns()) {
                    if (column == null) {
                        stringBuffer.append("(null), ");
                        continue;
                    }
                    stringBuffer.append(column.toString(false)).append(", ");
                }
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                stringBuffer.append(")");
            } else {
                stringBuffer.append("()");
            }
        }
        return stringBuffer.toString();
    }
}

