/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public abstract class AbstractSqlGenerator<T extends SqlStatement>
implements SqlGenerator<T> {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean generateStatementsIsVolatile(Database database) {
        return false;
    }

    @Override
    public boolean generateRollbackStatementsIsVolatile(Database database) {
        return false;
    }

    @Override
    public boolean supports(T statement, Database database) {
        return true;
    }

    @Override
    public Warnings warn(T statementType, Database database, SqlGeneratorChain<T> sqlGeneratorChain) {
        return sqlGeneratorChain.warn(statementType, database);
    }

    public boolean looksLikeFunctionCall(String value, Database database) {
        return value.startsWith("\"SYSIBM\"") || value.startsWith("to_date(") || value.equalsIgnoreCase(database.getCurrentDateTimeFunction());
    }

    public static void surroundWithCatalogSets(List<Sql> sql, String catalogName, Database database) {
        if (database instanceof MSSQLDatabase) {
            String defaultCatalogName = database.getDefaultCatalogName();
            sql.add(0, new UnparsedSql("USE [" + catalogName + "]", new DatabaseObject[0]));
            sql.add(new UnparsedSql("USE [" + defaultCatalogName + "]", new DatabaseObject[0]));
        }
    }
}

