/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import net.tirasa.connid.bundles.azure.dto.AvailableExtensionProperties;
import net.tirasa.connid.bundles.azure.dto.AzureError;
import net.tirasa.connid.bundles.azure.dto.AzureObject;
import net.tirasa.connid.bundles.azure.dto.AzurePagedObject;
import net.tirasa.connid.bundles.azure.dto.Group;
import net.tirasa.connid.bundles.azure.dto.License;
import net.tirasa.connid.bundles.azure.dto.MemberOf;
import net.tirasa.connid.bundles.azure.dto.PagedGroups;
import net.tirasa.connid.bundles.azure.dto.PagedUsers;
import net.tirasa.connid.bundles.azure.dto.PasswordProfile;
import net.tirasa.connid.bundles.azure.dto.SubscribedSku;
import net.tirasa.connid.bundles.azure.dto.User;
import net.tirasa.connid.bundles.azure.service.AzureService;
import net.tirasa.connid.bundles.azure.service.NoSuchEntityException;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;

public class AzureRestAPI {
    private static final Log LOG = Log.getLog(AzureRestAPI.class);
    private final AzureService azureService;

    public AzureRestAPI(AzureService azureService) {
        this.azureService = azureService;
    }

    public List<User> getAllUsers() {
        WebClient webClient = this.azureService.getWebclient("users", null);
        return this.doGetAllUsers(webClient);
    }

    public PagedUsers getAllUsers(int pageSize) {
        WebClient webClient = this.azureService.getWebclient("users", "$top=" + String.valueOf(pageSize));
        return (PagedUsers)PagedUsers.class.cast(this.getAllPagedObjects("users", webClient, null));
    }

    public PagedUsers getAllUsersNextPage(int pageSize, String skipToken, Boolean backward) {
        WebClient webClient = this.azureService.getWebclient("users", "$top=" + String.valueOf(pageSize) + (StringUtil.isNotBlank((String)skipToken) ? "&$skiptoken=" + skipToken : "") + (backward != null && backward != false ? "previous-page=true" : ""));
        return (PagedUsers)PagedUsers.class.cast(this.getAllPagedObjects("users", webClient, skipToken));
    }

    public User getUser(String userId) {
        WebClient webClient = this.azureService.getWebclient("users/" + userId, null);
        return (User)User.class.cast(this.doGetObject("users", webClient));
    }

    public List<User> getUsersByName(String username) {
        WebClient webClient = this.azureService.getWebclient("users", "$filter=displayName eq '" + username + "' or " + "mailNickname" + " eq '" + username + "'");
        List<Object> users = null;
        try {
            users = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), User[].class));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Groups", ex);
        }
        return users;
    }

    public List<User> getAllMembersOfGroup(String groupId) {
        WebClient webClient = this.azureService.getWebclient("groups/" + groupId + "/members", null);
        List<Object> users = null;
        try {
            users = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), User[].class));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Users", ex);
        }
        return users;
    }

    public void addUserToGroup(String userId, String groupId) {
        WebClient webClient = this.azureService.getWebclient("groups/" + groupId + "/$links/members", null);
        WebClient webClientUser = this.azureService.getWebclient("directoryObjects/" + userId, null);
        ObjectNode json = AzureUtils.MAPPER.createObjectNode();
        json.set("url", (JsonNode)json.textNode(webClientUser.getCurrentURI().toString()));
        try {
            webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)json));
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While adding User to Group", ex);
        }
    }

    public void deleteUserFromGroup(String userId, String groupId) {
        WebClient webClient = this.azureService.getWebclient("groups/" + groupId + "/$links/members/" + userId, null);
        Response response = webClient.delete();
        if (response.getStatus() != 204) {
            throw new NoSuchEntityException(userId);
        }
    }

    public List<Group> getAllGroups() {
        WebClient webClient = this.azureService.getWebclient("groups", null);
        return this.doGetAllGroups(webClient);
    }

    public PagedGroups getAllGroups(int pageSize) {
        WebClient webClient = this.azureService.getWebclient("groups", "$top=" + String.valueOf(pageSize));
        return (PagedGroups)PagedGroups.class.cast(this.getAllPagedObjects("groups", webClient, null));
    }

    public PagedGroups getAllGroupsNextPage(int pageSize, String skipToken, Boolean backward) {
        WebClient webClient = this.azureService.getWebclient("groups", "$top=" + String.valueOf(pageSize) + (StringUtil.isNotBlank((String)skipToken) ? "&$skiptoken=" + skipToken : "") + (backward != null && backward != false ? "previous-page=true" : ""));
        return (PagedGroups)PagedGroups.class.cast(this.getAllPagedObjects("groups", webClient, skipToken));
    }

    public List<Group> getAllGroupsForUser(String userId) {
        WebClient webClient = this.azureService.getWebclient("users/" + userId + "/$links/memberOf", null);
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            JsonNode json = this.azureService.doGetFromAzure(webClient);
            List<String> groupIds = this.azureService.extractUsersFromGroupMemberships(json);
            for (String groupId : groupIds) {
                Group group = this.getGroup(groupId);
                if (group == null) continue;
                groups.add(group);
            }
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While getting groups for User " + userId, ex);
        }
        return groups;
    }

    public Group getGroup(String groupId) {
        WebClient webClient = this.azureService.getWebclient("groups/" + groupId, null);
        return (Group)Group.class.cast(this.doGetObject("groups", webClient));
    }

    public List<Group> getGroupsByName(String groupName) {
        WebClient webClient = this.azureService.getWebclient("groups/", "$filter=displayName eq '" + groupName + "'");
        List<Object> groups = null;
        try {
            groups = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), Group[].class));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Groups", ex);
        }
        return groups;
    }

    public List<Group> getGroupsStartsWith(String groupnamePart) {
        WebClient webClient = this.azureService.getWebclient("groups/", "$filter=startswith(displayName,'" + groupnamePart + "')");
        List<Object> groups = null;
        try {
            groups = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), Group[].class));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Groups", ex);
        }
        return groups;
    }

    public List<Group> getGroupsOrderdByAsc(String attribute) {
        String attributeToUse = attribute;
        if (StringUtil.isBlank((String)attributeToUse)) {
            attributeToUse = "displayName";
        }
        WebClient webClient = this.azureService.getWebclient("groups/", "$orderby=" + attributeToUse);
        List<Object> groups = null;
        try {
            groups = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), Group[].class));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Users", ex);
        }
        return groups;
    }

    public User createUser(User user) {
        return (User)User.class.cast(this.doCreate(user));
    }

    public Group createGroup(Group group) {
        return (Group)Group.class.cast(this.doCreate(group));
    }

    public User updateUser(User user) {
        return (User)User.class.cast(this.doUpdate(user));
    }

    public Group updateGroup(Group group) {
        return (Group)Group.class.cast(this.doUpdate(group));
    }

    public void deleteUser(String userId) {
        WebClient webClient = this.azureService.getWebclient("users/" + userId, null);
        if (webClient.delete().getStatus() != 204) {
            throw new NoSuchEntityException(userId);
        }
    }

    public void deleteGroup(String groupId) {
        WebClient webClient = this.azureService.getWebclient("groups/" + groupId, null);
        if (webClient.delete().getStatus() != 204) {
            throw new NoSuchEntityException(groupId);
        }
    }

    public AvailableExtensionProperties getAvailableExtensionProperties(String userId, boolean isSyncedFromOnPremises) {
        WebClient webClient = this.azureService.getWebclient("getAvailableExtensionProperties", null);
        AvailableExtensionProperties availableExtensionProperties = null;
        try {
            ObjectNode body = AzureUtils.MAPPER.createObjectNode();
            body.set("isSyncedFromOnPremises", (JsonNode)body.booleanNode(isSyncedFromOnPremises));
            Response response = webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)body));
            String responseAsString = (String)response.readEntity(String.class);
            if (response.getStatus() != 200) {
                AzureError.sendError("get available extension properties for User " + userId, response);
            }
            availableExtensionProperties = (AvailableExtensionProperties)AzureUtils.MAPPER.readValue(responseAsString, AvailableExtensionProperties.class);
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While getting available extension properties ", ex);
        }
        return availableExtensionProperties;
    }

    public List<SubscribedSku> getCurrentTenantSubscriptions() {
        WebClient webClient = this.azureService.getWebclient("subscribedSkus", null);
        List<Object> results = null;
        try {
            results = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), SubscribedSku[].class));
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While getting current tenant available subscriptions", ex);
        }
        return results;
    }

    public List<String> getCurrentTenantSkuIds(boolean onlyEnabled) {
        ArrayList<String> result = new ArrayList<String>();
        List<SubscribedSku> subscriptions = this.getCurrentTenantSubscriptions();
        try {
            for (SubscribedSku subscription : subscriptions) {
                if (onlyEnabled && subscription.getCapabilityStatus().equalsIgnoreCase("enabled")) {
                    result.add(subscription.getSkuId());
                    continue;
                }
                if (onlyEnabled) continue;
                result.add(subscription.getSkuId());
            }
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While getting current tenant available licenses", ex);
        }
        return result;
    }

    public void assignLicense(String userId, License assignedLicense) {
        WebClient webClient = this.azureService.getWebclient("users/" + userId + "/assignLicense", null);
        try {
            Response response = webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)assignedLicense));
            if (response.getStatus() != 200) {
                AzureError.sendError("assign license to User " + userId, response);
            }
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While assigning license", ex);
        }
    }

    public Boolean isMemberOf(String memberId, String groupId) {
        WebClient webClient = this.azureService.getWebclient("isMemberOf", null);
        Boolean result = null;
        try {
            MemberOf memberOf = new MemberOf();
            memberOf.setMemberId(memberId);
            memberOf.setGroupId(groupId);
            Response response = webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)memberOf));
            String responseAsString = (String)response.readEntity(String.class);
            if (response.getStatus() != 200) {
                AzureError.sendError("check whether member " + memberId + " is member of " + groupId, response);
            }
            result = AzureUtils.MAPPER.readTree(responseAsString).get("value").asBoolean();
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While checking membership", ex);
        }
        return result;
    }

    public List<String> getMemberGroups(String resourceCollection, String resourceId, boolean securityEnabledOnly) {
        WebClient webClient = this.azureService.getWebclient(resourceCollection + "/" + resourceId + "/getMemberGroups", null);
        return this.doGetMembers(webClient, resourceId, securityEnabledOnly);
    }

    public List<String> getMemberObjects(String resourceCollection, String resourceId, boolean securityEnabledOnly) {
        WebClient webClient = this.azureService.getWebclient(resourceCollection + "/" + resourceId + "/getMemberObjects", null);
        return this.doGetMembers(webClient, resourceId, securityEnabledOnly);
    }

    private List<String> doGetMembers(WebClient webClient, String resourceId, boolean securityEnabledOnly) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            JsonNode responseObj;
            ObjectNode body = AzureUtils.MAPPER.createObjectNode();
            body.set("securityEnabledOnly", (JsonNode)body.booleanNode(securityEnabledOnly));
            Response response = webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)body));
            String responseAsString = (String)response.readEntity(String.class);
            if (response.getStatus() != 200) {
                AzureError.sendError("get members groups for resource " + resourceId, response);
            }
            if ((responseObj = AzureUtils.MAPPER.readTree(responseAsString)) != null && responseObj.isArray()) {
                for (JsonNode value : responseObj.get("value")) {
                    result.add(value.textValue());
                }
            }
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While getting groups members", ex);
        }
        return result;
    }

    private AzureObject doCreate(AzureObject obj) {
        WebClient webClient = this.azureService.getWebclient(obj instanceof Group ? "groups" : "users", null);
        AzureObject body = obj;
        if (body instanceof User) {
            User user = (User)User.class.cast(body);
            user.setObjectType("User");
            if (user.getAccountEnabled() == null) {
                user.setAccountEnabled(true);
            }
            this.checkUserValid(user);
            if (StringUtil.isBlank((String)user.getUserPrincipalName())) {
                user.setUserPrincipalName(user.getMailNickname() + "@" + this.azureService.getDomain());
            }
            PasswordProfile passwordProfile = new PasswordProfile();
            passwordProfile.setPassword(user.getPassword());
            passwordProfile.setEnforceChangePasswordPolicy(false);
            passwordProfile.setForceChangePasswordNextLogin(false);
            user.setPasswordProfile(passwordProfile);
        } else {
            Group group = (Group)Group.class.cast(body);
            group.setObjectType("Group");
            group.setMailEnabled(false);
            group.setSecurityEnabled(true);
            this.checkGroupValid(group);
        }
        try {
            Response response = webClient.post((Object)AzureUtils.MAPPER.writeValueAsString((Object)body));
            if (response == null) {
                AzureUtils.handleGeneralError("While creating User - no response");
            } else {
                String value = obj instanceof Group ? "objectId" : "objectId";
                String responseAsString = (String)response.readEntity(String.class);
                JsonNode responseObj = AzureUtils.MAPPER.readTree(responseAsString);
                if (responseObj.hasNonNull(value)) {
                    body.setObjectId(responseObj.get(value).asText());
                } else {
                    AzureUtils.handleGeneralError("While getting " + value + " value for created User - Response : " + responseAsString);
                }
            }
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While creating User", ex);
        }
        return body;
    }

    private AzureObject doUpdate(AzureObject obj) {
        WebClient webClient;
        AzureObject updated = obj;
        if (updated instanceof User) {
            User updatedUser = (User)User.class.cast(updated);
            webClient = this.azureService.getWebclient("users/" + (StringUtils.isBlank((CharSequence)updatedUser.getUserPrincipalName()) ? updatedUser.getObjectId() : updatedUser.getUserPrincipalName()), null);
            if (updatedUser.getPassword() != null && StringUtil.isNotBlank((String)AzureUtils.getPasswordValue(updatedUser.getPassword()))) {
                PasswordProfile passwordProfile = new PasswordProfile();
                passwordProfile.setPassword(updatedUser.getPassword());
                passwordProfile.setForceChangePasswordNextLogin(false);
                updatedUser.setPasswordProfile(passwordProfile);
            }
            updated = updatedUser;
        } else {
            webClient = this.azureService.getWebclient("groups/" + obj.getObjectId(), null);
        }
        try {
            WebClient.getConfig((Object)webClient).getRequestContext().put("use.async.http.conduit", true);
            webClient.invoke("PATCH", (Object)AzureUtils.MAPPER.writeValueAsString((Object)updated));
        }
        catch (JsonProcessingException ex) {
            AzureUtils.handleGeneralError("While updating User", (Exception)((Object)ex));
        }
        return obj;
    }

    private List<User> doGetAllUsers(WebClient webClient) {
        List<Object> users = null;
        try {
            users = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), User[].class));
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Users", ex);
        }
        return users;
    }

    private List<Group> doGetAllGroups(WebClient webClient) {
        List<Object> groups = null;
        try {
            groups = Arrays.asList((Object[])AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), Group[].class));
        }
        catch (IOException ex) {
            AzureUtils.handleGeneralError("While converting from JSON to Groups", ex);
        }
        return groups;
    }

    private AzurePagedObject getAllPagedObjects(String type, WebClient webClient, String skipToken) {
        AzurePagedObject pagedObj = null;
        if (type.equals("users")) {
            PagedUsers pagedUsers = new PagedUsers();
            pagedUsers.setUsers(this.doGetAllUsers(webClient));
            pagedUsers.setSkipToken(StringUtil.isNotBlank((String)skipToken) ? skipToken : this.azureService.getPagedResultsSkipToken());
            pagedObj = pagedUsers;
        } else if (type.equals("groups")) {
            PagedGroups pagedGroups = new PagedGroups();
            pagedGroups.setGroups(this.doGetAllGroups(webClient));
            pagedGroups.setSkipToken(StringUtil.isNotBlank((String)skipToken) ? skipToken : this.azureService.getPagedResultsSkipToken());
            pagedObj = pagedGroups;
        }
        return pagedObj;
    }

    private AzureObject doGetObject(String type, WebClient webClient) {
        AzureObject obj = null;
        if (type.equals("users")) {
            try {
                obj = (AzureObject)AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), User.class);
            }
            catch (IOException ex) {
                AzureUtils.handleGeneralError("While converting from JSON to User", ex);
            }
        } else if (type.equals("groups")) {
            try {
                obj = (AzureObject)AzureUtils.MAPPER.readValue(this.azureService.doGetFromAzure(webClient).toString(), Group.class);
            }
            catch (IOException ex) {
                AzureUtils.handleGeneralError("While converting from JSON to Group", ex);
            }
        }
        return obj;
    }

    private void checkUserValid(User user) {
        if (user.getAccountEnabled() == null) {
            AzureUtils.handleGeneralError("User 'accountEnabled' value is required");
        } else if (StringUtil.isBlank((String)user.getObjectType())) {
            AzureUtils.handleGeneralError("User 'objectType' value is required");
        } else if (StringUtil.isBlank((String)user.getDisplayName())) {
            AzureUtils.handleGeneralError("User 'displayName' value is required");
        } else if (StringUtil.isBlank((String)user.getMailNickname())) {
            AzureUtils.handleGeneralError("User 'mainNickname' value is required");
        } else if (user.getPassword() == null || StringUtil.isBlank((String)AzureUtils.getPasswordValue(user.getPassword()))) {
            AzureUtils.handleGeneralError("User 'password' value is required");
        }
    }

    private void checkGroupValid(Group group) {
        if (StringUtil.isBlank((String)group.getDisplayName())) {
            AzureUtils.handleGeneralError("Group 'displayName' value is required");
        } else if (group.getMailEnabled() == null) {
            AzureUtils.handleGeneralError("Group 'mailEnabled' value is required");
        } else if (StringUtil.isBlank((String)group.getMailNickname())) {
            AzureUtils.handleGeneralError("Group 'mailNickname' value is required");
        } else if (group.getSecurityEnabled() == null) {
            AzureUtils.handleGeneralError("Group 'securityEnabled' value is required");
        }
    }
}

