/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Set;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PasswordProfile {
    @JsonProperty
    private String password;
    @JsonProperty
    private Boolean forceChangePasswordNextLogin;
    @JsonProperty
    private Boolean enforceChangePasswordPolicy;

    public String getPassword() {
        return this.password != null ? SecurityUtil.decrypt((GuardedString)AzureUtils.createPassword(this.password)) : null;
    }

    public void setPassword(GuardedString password) {
        this.password = password != null ? AzureUtils.getPasswordValue(password) : null;
    }

    public Boolean getForceChangePasswordNextLogin() {
        return this.forceChangePasswordNextLogin;
    }

    public void setForceChangePasswordNextLogin(Boolean forceChangePasswordNextLogin) {
        this.forceChangePasswordNextLogin = forceChangePasswordNextLogin;
    }

    public Boolean getEnforceChangePasswordPolicy() {
        return this.enforceChangePasswordPolicy;
    }

    public void setEnforceChangePasswordPolicy(Boolean enforceChangePasswordPolicy) {
        this.enforceChangePasswordPolicy = enforceChangePasswordPolicy;
    }

    private GuardedString asGuardedString() {
        return this.password == null ? null : new GuardedString(this.password.toCharArray());
    }

    public Set<Attribute> toAttributes() {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        attrs.add(AttributeBuilder.build((String)"password", (Object[])new Object[]{this.asGuardedString()}));
        return attrs;
    }

    public String toString() {
        return "PasswordProfile [password=" + this.asGuardedString() + ", forceChangePasswordNextLogin=" + this.forceChangePasswordNextLogin + "]";
    }
}

