/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequestCancel", path="/api/flowable/userRequests/${executionId}")
public class UserRequestCancelResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            if (!"DELETE".equals(request.getMethod())) {
                throw new UnsupportedOperationException("Unsupported operation, only DELETE allowed");
            }
            PageParameters parameters = attributes.getParameters();
            StringValue executionId = parameters.get("executionId");
            IRequestParameters requestParameters = attributes.getRequest().getQueryParameters();
            StringValue reason = requestParameters.getParameterValue("reason");
            LOG.debug("Cancel Flowable User Request with execution id [{}] for user [{}] with reason [{}]", new Object[]{executionId, SyncopeEnduserSession.get().getSelfTO().getUsername(), reason});
            if (executionId.isEmpty()) {
                throw new IllegalArgumentException("Empty executionId, please provide a value");
            }
            ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).cancelRequest(executionId.toString(), reason.toString());
            final String outcomeMessage = String.format("User Request with execution id [%s] successfully canceled for User [%s]", executionId.toString(), SyncopeEnduserSession.get().getSelfTO().getUsername());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)outcomeMessage);
                }
            });
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error cancelling User Request for [{}]", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

