/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RequestListenerInterface {
    private static final Map<String, RequestListenerInterface> interfaces = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(RequestListenerInterface.class);
    private final String name;
    private boolean includeRenderCount = true;
    private boolean renderPageAfterInvocation = true;
    final Class<? extends IRequestListener> listenerInterfaceClass;

    public static RequestListenerInterface forName(String interfaceName) {
        return interfaces.get(interfaceName);
    }

    public RequestListenerInterface(Class<? extends IRequestListener> listenerInterfaceClass) {
        this.listenerInterfaceClass = listenerInterfaceClass;
        if (!IRequestListener.class.isAssignableFrom(listenerInterfaceClass)) {
            throw new IllegalArgumentException("Class " + listenerInterfaceClass + " must extend IRequestListener");
        }
        this.name = Classes.simpleName(listenerInterfaceClass);
        this.register();
    }

    public Class<? extends IRequestListener> getListenerInterfaceClass() {
        return this.listenerInterfaceClass;
    }

    public RequestListenerInterface setIncludeRenderCount(boolean includeRenderCount) {
        this.includeRenderCount = includeRenderCount;
        return this;
    }

    public boolean isIncludeRenderCount() {
        return this.includeRenderCount;
    }

    public RequestListenerInterface setRenderPageAfterInvocation(boolean renderPageAfterInvocation) {
        this.renderPageAfterInvocation = renderPageAfterInvocation;
        return this;
    }

    public boolean isRenderPageAfterInvocation() {
        return this.renderPageAfterInvocation;
    }

    public final String getName() {
        return this.name;
    }

    public final void invoke(IRequestableComponent rcomponent) {
        Component component = (Component)rcomponent;
        if (!component.canCallListener()) {
            log.info("component not enabled or visible; ignoring call. Component: " + component);
            throw new ListenerInvocationNotAllowedException(component, null, "Component rejected interface invocation");
        }
        this.internalInvoke(component, component);
    }

    public final void invoke(IRequestableComponent rcomponent, Behavior behavior) {
        Component component = (Component)rcomponent;
        if (!behavior.canCallListener(component)) {
            log.warn("behavior not enabled; ignore call. Behavior {} at component {}", (Object)behavior, (Object)component);
            throw new ListenerInvocationNotAllowedException(component, behavior, "Behavior rejected interface invocation. ");
        }
        this.internalInvoke(component, behavior);
    }

    private void internalInvoke(Component component, Object target) {
        Page page = component.getPage();
        if (!page.isInitialized()) {
            page.internalInitialize();
        }
        ((IRequestListener)target).onRequest();
    }

    public void register() {
        this.registerRequestListenerInterface(this);
    }

    public String toString() {
        return "[RequestListenerInterface name=" + this.name + "]";
    }

    private void registerRequestListenerInterface(RequestListenerInterface requestListenerInterface) {
        RequestListenerInterface existingInterface = RequestListenerInterface.forName(requestListenerInterface.getName());
        if (existingInterface == null) {
            interfaces.put(requestListenerInterface.getName(), requestListenerInterface);
            log.info("registered listener interface " + this);
        }
    }

    public static Collection<RequestListenerInterface> getRegisteredInterfaces() {
        return Collections.unmodifiableCollection(interfaces.values());
    }
}

