/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class DomainTransactionInterceptor
extends TransactionInterceptor {
    private static final long serialVersionUID = 5113728988680448551L;
    private static final Logger LOG = LoggerFactory.getLogger(DomainTransactionInterceptor.class);

    public TransactionAttributeSource getTransactionAttributeSource() {
        TransactionAttributeSource origTxAttrSource = super.getTransactionAttributeSource();
        return (method, targetClass) -> {
            TransactionAttribute txAttr = origTxAttrSource.getTransactionAttribute(method, targetClass);
            if (txAttr instanceof DefaultTransactionAttribute) {
                ((DefaultTransactionAttribute)txAttr).setQualifier(AuthContextUtils.getDomain());
            }
            return txAttr;
        };
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return super.invoke(invocation);
        }
        catch (Throwable e) {
            LOG.debug("Error during {} invocation", (Object)invocation.getMethod(), (Object)e);
            throw e;
        }
    }
}

