/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;

public abstract class AbstractGroupableRelatable<L extends Any<P>, M extends Membership<L>, P extends GroupablePlainAttr<L, M>, R extends Any<?>, REL extends Relationship<L, R>>
extends AbstractAny<P>
implements GroupableRelatable<L, M, P, R, REL> {
    private static final long serialVersionUID = -2269285197388729673L;

    protected abstract List<? extends P> internalGetPlainAttrs();

    public boolean remove(P attr) {
        return this.internalGetPlainAttrs().remove(attr);
    }

    public Optional<? extends P> getPlainAttr(String plainSchema) {
        return this.internalGetPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() == null && plainSchema.equals(plainAttr.getSchema().getKey())).findFirst();
    }

    public Optional<? extends P> getPlainAttr(String plainSchema, Membership<?> membership) {
        return this.internalGetPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() != null && plainAttr.getMembership().equals(membership) && plainSchema.equals(plainAttr.getSchema().getKey())).findFirst();
    }

    public List<? extends P> getPlainAttrs() {
        return this.internalGetPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && plainAttr.getMembership() == null).collect(Collectors.toList());
    }

    public Collection<? extends P> getPlainAttrs(String plainSchema) {
        return this.internalGetPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && plainSchema.equals(plainAttr.getSchema().getKey())).collect(Collectors.toList());
    }

    public Collection<? extends P> getPlainAttrs(Membership<?> membership) {
        return this.internalGetPlainAttrs().stream().filter(plainAttr -> plainAttr != null && plainAttr.getSchema() != null && membership.equals(plainAttr.getMembership())).collect(Collectors.toList());
    }

    public Optional<? extends M> getMembership(String groupKey) {
        return this.getMemberships().stream().filter(membership -> groupKey != null && groupKey.equals(((Group)membership.getRightEnd()).getKey())).findFirst();
    }

    public Collection<? extends REL> getRelationships(RelationshipType relationshipType) {
        return this.getRelationships().stream().filter(relationship -> relationshipType != null && relationshipType.equals(relationship.getType())).collect(Collectors.toList());
    }

    public Collection<? extends REL> getRelationships(String otherEndKey) {
        return this.getRelationships().stream().filter(relationship -> otherEndKey != null && otherEndKey.equals(relationship.getRightEnd().getKey())).collect(Collectors.toList());
    }
}

