/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AbstractPromptReceiver;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Main {
    private static final String CLIENTSECRETS_LOCATION = "client_secrets.json";
    public static final String ADMIN_DIRECTORY_GROUP = "https://www.googleapis.com/auth/admin.directory.group";
    public static final String ADMIN_DIRECTORY_ORGUNIT = "https://www.googleapis.com/auth/admin.directory.orgunit";
    public static final String ADMIN_DIRECTORY_USER = "https://www.googleapis.com/auth/admin.directory.user";
    public static final String ADMIN_ENTERPRISE_LICENSE = "https://www.googleapis.com/auth/apps.licensing";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/admin.directory.group", "https://www.googleapis.com/auth/admin.directory.orgunit", "https://www.googleapis.com/auth/admin.directory.user", "https://www.googleapis.com/auth/apps.licensing");
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            File clientJson = new File(args[0]);
            if (clientJson.isDirectory()) {
                clientJson = new File(clientJson, CLIENTSECRETS_LOCATION);
            }
            if (clientJson.exists() && clientJson.isFile()) {
                Map<String, Object> configMap = Main.getConfigurationMap(clientJson);
                System.out.println(JSON_FACTORY.toPrettyString(configMap));
                return;
            }
            System.err.println("Invalid client secret path. File not exits " + clientJson);
        }
        String fileName = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
        System.out.print("Usage: java -jar " + fileName + " <path to client_secrets.json>");
    }

    static Map<String, Object> getConfigurationMap(File clientJson) throws IOException, URISyntaxException {
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new FileReader(clientJson));
        Credential credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setAccessType("offline").setApprovalPrompt("force").setDataStoreFactory((DataStoreFactory)MemoryDataStoreFactory.getDefaultInstance()).build(), (VerificationCodeReceiver)new AbstractPromptReceiver(){

            public String getRedirectUri() throws IOException {
                return "urn:ietf:wg:oauth:2.0:oob";
            }
        }).authorize("user");
        LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>(3);
        configMap.put("clientId", clientSecrets.getDetails().getClientId());
        configMap.put("clientSecret", clientSecrets.getDetails().getClientSecret());
        configMap.put("refreshToken", credential.getRefreshToken());
        return configMap;
    }
}

