/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class RealmUtils {
    public static String getGroupOwnerRealm(String realmPath, String groupKey) {
        return realmPath + "@" + groupKey;
    }

    public static boolean normalizingAddTo(Set<String> realms, String newRealm) {
        boolean dontAdd = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String realm : realms) {
            if (newRealm.startsWith(realm)) {
                dontAdd = true;
                continue;
            }
            if (!realm.startsWith(newRealm)) continue;
            toRemove.add(realm);
        }
        realms.removeAll(toRemove);
        if (!dontAdd) {
            realms.add(newRealm);
        }
        return !dontAdd;
    }

    public static Set<String> normalize(Collection<String> realms) {
        HashSet<String> normalized = new HashSet<String>();
        if (realms != null) {
            realms.forEach(realm -> RealmUtils.normalizingAddTo(normalized, realm));
        }
        return normalized;
    }

    public static Set<String> getEffective(Set<String> allowedRealms, String requestedRealm) {
        Set<String> allowed = RealmUtils.normalize(allowedRealms);
        HashSet<String> requested = new HashSet<String>();
        requested.add(requestedRealm);
        HashSet<String> effective = new HashSet<String>();
        effective.addAll(requested.stream().filter(new StartsWithPredicate(allowed)).collect(Collectors.toSet()));
        effective.addAll(allowed.stream().filter(new StartsWithPredicate(requested)).collect(Collectors.toSet()));
        if (allowedRealms != null) {
            effective.addAll(allowedRealms.stream().filter(new DynRealmsPredicate()).collect(Collectors.toSet()));
        }
        return effective;
    }

    private RealmUtils() {
    }

    public static class DynRealmsPredicate
    implements Predicate<String> {
        @Override
        public boolean test(String realm) {
            return !realm.startsWith("/");
        }
    }

    private static class StartsWithPredicate
    implements Predicate<String> {
        private final Collection<String> targets;

        StartsWithPredicate(Collection<String> targets) {
            this.targets = targets;
        }

        @Override
        public boolean test(String realm) {
            return this.targets.stream().anyMatch(realm::startsWith);
        }
    }
}

